/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.configuration;

import org.dspace.xoai.app.BasicConfiguration;
import org.dspace.xoai.services.api.xoai.ItemRepositoryResolver;
import org.dspace.xoai.services.impl.xoai.DSpaceItemRepositoryResolver;
import org.jtwig.spring.JtwigViewResolver;
import org.jtwig.spring.boot.config.JtwigViewResolverConfigurer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@Import(value={BasicConfiguration.class})
@ComponentScan(value={"org.dspace.xoai.controller"})
public class OAIWebConfig
extends WebMvcConfigurerAdapter
implements JtwigViewResolverConfigurer {
    @Value(value="${oai.path:oai}")
    private String oaiPath;
    private static final String TWIG_HTML_EXTENSION = ".twig.html";
    private static final String VIEWS_LOCATION = "classpath:/templates/";

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/" + this.oaiPath + "/static/**"}).addResourceLocations(new String[]{"classpath:/static/"}).setCachePeriod(Integer.valueOf(Integer.MAX_VALUE));
    }

    public void configure(JtwigViewResolver viewResolver) {
        viewResolver.setPrefix(VIEWS_LOCATION);
        viewResolver.setSuffix(TWIG_HTML_EXTENSION);
    }

    @Bean
    public ItemRepositoryResolver xoaiItemRepositoryResolver() {
        return new DSpaceItemRepositoryResolver();
    }
}

