/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.app.webui.submit.JSPStep;
import org.dspace.app.webui.submit.JSPStepManager;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;

public class JSPSelectCollectionStep
extends JSPStep {
    private static final String SELECT_COLLECTION_JSP = "/submit/select-collection.jsp";
    private static Logger log = Logger.getLogger(JSPSelectCollectionStep.class);
    private CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();

    public void doPreProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        Context.Mode originalMode = context.getCurrentMode();
        context.setMode(Context.Mode.READ_ONLY);
        UUID collectionID = Util.getUUIDParameter((HttpServletRequest)request, (String)"collection");
        Collection col = null;
        if (collectionID != null) {
            col = (Collection)this.collectionService.find(context, collectionID);
        }
        if (col != null) {
            log.debug((Object)("Select Collection page skipped, since a Collection ID was already found.  Collection ID=" + collectionID));
        } else {
            Community com = UIUtil.getCommunityLocation((HttpServletRequest)request);
            List collections = com != null ? this.collectionService.findAuthorized(context, com, 3) : this.collectionService.findAuthorizedOptimized(context, 3);
            if (collectionID == null) {
                request.setAttribute("no.collection", (Object)Boolean.TRUE);
            }
            request.setAttribute("collections", (Object)collections);
            JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)SELECT_COLLECTION_JSP);
        }
        context.setMode(originalMode);
    }

    public void doPostProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, int status) throws ServletException, IOException, SQLException, AuthorizeException {
        if (status == 1) {
            request.setAttribute("no.collection", (Object)Boolean.TRUE);
            this.doPreProcessing(context, request, response, subInfo);
        } else if (status == 2) {
            JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)request.getParameter("collection"), (int)3);
        }
    }

    public String getReviewJSP(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) {
        return "";
    }
}

