/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.SupervisedItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.eperson.service.SupervisorService;

public class SuperviseServlet
extends DSpaceServlet {
    private static final Logger log = Logger.getLogger(SuperviseServlet.class);
    private final transient GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    private final transient SupervisorService supervisorService = EPersonServiceFactory.getInstance().getSupervisorService();
    private final transient SupervisedItemService supervisedItemService = ContentServiceFactory.getInstance().getSupervisedItemService();
    private final transient WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();

    protected void doDSGet(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSPost(c, request, response);
    }

    protected void doDSPost(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_base");
        if (button.equals("submit_add")) {
            this.showLinkPage(c, request, response);
        } else if (button.equals("submit_view")) {
            this.showListPage(c, request, response);
        } else if (button.equals("submit_base")) {
            this.showMainPage(c, request, response);
        } else if (button.equals("submit_link")) {
            if (this.validateAddForm(c, request, response)) {
                this.addSupervisionOrder(c, request, response);
                this.showMainPage(c, request, response);
            }
        } else if (button.equals("submit_remove")) {
            this.showConfirmRemovePage(c, request, response);
        } else if (button.equals("submit_doremove")) {
            this.removeSupervisionOrder(c, request, response);
            this.showMainPage(c, request, response);
        }
    }

    private void showConfirmRemovePage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        int wsItemID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"siID");
        UUID groupID = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"gID");
        WorkspaceItem wsItem = this.workspaceItemService.find(context, wsItemID);
        Group group = (Group)this.groupService.find(context, groupID);
        request.setAttribute("wsItem", (Object)wsItem);
        request.setAttribute("group", (Object)group);
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/supervise-confirm-remove.jsp");
    }

    private void showLinkPage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        List groups = this.groupService.findAll(context, 1);
        List wsItems = this.workspaceItemService.findAll(context);
        request.setAttribute("groups", (Object)groups);
        request.setAttribute("wsItems", (Object)wsItems);
        if (wsItems.size() == 0) {
            request.setAttribute("errorKey", (Object)"jsp.dspace-admin.supervise-no-workspaceitem.no-wsitems");
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/supervise-no-workspaceitem.jsp");
        } else {
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/supervise-link.jsp");
        }
    }

    private void showMainPage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/supervise-main.jsp");
    }

    private void showListPage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        List si = this.supervisedItemService.getAll(context);
        request.setAttribute("supervised", (Object)si);
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/supervise-list.jsp");
    }

    void addSupervisionOrder(Context context, HttpServletRequest request, HttpServletResponse response) throws SQLException, AuthorizeException, ServletException, IOException {
        UUID groupID = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"TargetGroup");
        int wsItemID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"TargetWSItem");
        int policyType = UIUtil.getIntParameter((HttpServletRequest)request, (String)"PolicyType");
        Group group = (Group)this.groupService.find(context, groupID);
        WorkspaceItem wi = this.workspaceItemService.find(context, wsItemID);
        this.supervisorService.add(context, group, wi, policyType);
        log.info((Object)LogManager.getHeader((Context)context, (String)"Supervision Order Set", (String)("workspace_item_id=" + wsItemID + ",eperson_group_id=" + groupID)));
        context.complete();
    }

    void removeSupervisionOrder(Context context, HttpServletRequest request, HttpServletResponse response) throws SQLException, AuthorizeException, ServletException, IOException {
        int wsItemID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"siID");
        UUID groupID = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"gID");
        WorkspaceItem wi = this.workspaceItemService.find(context, wsItemID);
        Group group = (Group)this.groupService.find(context, groupID);
        this.supervisorService.remove(context, wi, group);
        log.info((Object)LogManager.getHeader((Context)context, (String)"Supervision Order Removed", (String)("workspace_item_id=" + wsItemID + ",eperson_group_id=" + groupID)));
        context.complete();
    }

    private boolean validateAddForm(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        Group group;
        UUID groupID = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"TargetGroup");
        int wsItemID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"TargetWSItem");
        if (wsItemID == -1) {
            request.setAttribute("errorKey", (Object)"jsp.dspace-admin.supervise-no-workspaceitem.unselected");
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/supervise-no-workspaceitem.jsp");
            return false;
        }
        WorkspaceItem wi = this.workspaceItemService.find(context, wsItemID);
        boolean invalid = this.supervisorService.isOrder(context, wi, group = (Group)this.groupService.find(context, groupID));
        if (invalid) {
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/supervise-duplicate.jsp");
            return false;
        }
        return true;
    }
}

