/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.FileUploadRequest;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.factory.HarvestServiceFactory;
import org.dspace.harvest.service.HarvestedCollectionService;

/*
 * Exception performing whole class analysis ignored.
 */
public class EditCommunitiesServlet
extends DSpaceServlet {
    public static final int START_EDIT_COMMUNITY = 1;
    public static final int START_DELETE_COMMUNITY = 2;
    public static final int START_CREATE_COMMUNITY = 3;
    public static final int START_EDIT_COLLECTION = 4;
    public static final int START_DELETE_COLLECTION = 5;
    public static final int START_CREATE_COLLECTION = 6;
    public static final int CONFIRM_EDIT_COMMUNITY = 7;
    public static final int CONFIRM_DELETE_COMMUNITY = 8;
    public static final int CONFIRM_EDIT_COLLECTION = 9;
    public static final int CONFIRM_DELETE_COLLECTION = 10;
    private static final Logger log = Logger.getLogger(EditCommunitiesServlet.class);
    private final transient CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    private static final transient CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private final transient BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    private final transient BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    private final transient HarvestedCollectionService harvestedCollectionService = HarvestServiceFactory.getInstance().getHarvestedCollectionService();
    private static final transient AuthorizeService myAuthorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    private final transient GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.showControls(context, request, response);
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String contentType = request.getContentType();
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
            this.processUploadLogo(context, request, response);
            return;
        }
        int action = UIUtil.getIntParameter((HttpServletRequest)request, (String)"action");
        Community community = (Community)this.communityService.find(context, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"community_id"));
        Community parentCommunity = (Community)this.communityService.find(context, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"parent_community_id"));
        Collection collection = (Collection)collectionService.find(context, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"collection_id"));
        request.setAttribute("community", (Object)community);
        request.setAttribute("parent", (Object)parentCommunity);
        request.setAttribute("collection", (Object)collection);
        if (request.getParameter("submit_cancel") != null) {
            this.showControls(context, request, response);
            return;
        }
        switch (action) {
            case 1: {
                this.storeAuthorizeAttributeCommunityEdit(context, request, community);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/edit-community.jsp");
                break;
            }
            case 2: {
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/confirm-delete-community.jsp");
                break;
            }
            case 3: {
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/edit-community.jsp");
                break;
            }
            case 4: {
                HarvestedCollection hc = this.harvestedCollectionService.find(context, collection);
                request.setAttribute("harvestInstance", (Object)hc);
                EditCommunitiesServlet.storeAuthorizeAttributeCollectionEdit((Context)context, (HttpServletRequest)request, (Collection)collection);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/edit-collection.jsp");
                break;
            }
            case 5: {
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/confirm-delete-collection.jsp");
                break;
            }
            case 6: {
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/collection-wizard?community_id=" + community.getID()));
                break;
            }
            case 7: {
                this.processConfirmEditCommunity(context, request, response, community);
                break;
            }
            case 8: {
                Community parent = (Community)this.communityService.getParentObject(context, (DSpaceObject)community);
                this.communityService.delete(context, (DSpaceObject)community);
                if (parent == null) {
                    response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/community-list"));
                } else {
                    response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/handle/" + parent.getHandle()));
                }
                context.complete();
                break;
            }
            case 9: {
                this.processConfirmEditCollection(context, request, response, community, collection);
                break;
            }
            case 10: {
                this.communityService.removeCollection(context, community, collection);
                request.removeAttribute("collection");
                this.showControls(context, request, response);
                context.complete();
                break;
            }
            default: {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
    }

    private void storeAuthorizeAttributeCommunityEdit(Context context, HttpServletRequest request, Community community) throws SQLException {
        try {
            AuthorizeUtil.authorizeManageAdminGroup((Context)context, (Community)community);
            request.setAttribute("admin_create_button", (Object)Boolean.TRUE);
        }
        catch (AuthorizeException authex) {
            request.setAttribute("admin_create_button", (Object)Boolean.FALSE);
        }
        try {
            AuthorizeUtil.authorizeRemoveAdminGroup((Context)context, (Community)community);
            request.setAttribute("admin_remove_button", (Object)Boolean.TRUE);
        }
        catch (AuthorizeException authex) {
            request.setAttribute("admin_remove_button", (Object)Boolean.FALSE);
        }
        if (myAuthorizeService.authorizeActionBoolean(context, (DSpaceObject)community, 2)) {
            request.setAttribute("delete_button", (Object)Boolean.TRUE);
        } else {
            request.setAttribute("delete_button", (Object)Boolean.FALSE);
        }
        try {
            AuthorizeUtil.authorizeManageCommunityPolicy((Context)context, (Community)community);
            request.setAttribute("policy_button", (Object)Boolean.TRUE);
        }
        catch (AuthorizeException authex) {
            request.setAttribute("policy_button", (Object)Boolean.FALSE);
        }
        if (myAuthorizeService.isAdmin(context, (DSpaceObject)community)) {
            request.setAttribute("admin_community", (Object)Boolean.TRUE);
        } else {
            request.setAttribute("admin_community", (Object)Boolean.FALSE);
        }
    }

    static void storeAuthorizeAttributeCollectionEdit(Context context, HttpServletRequest request, Collection collection) throws SQLException {
        if (myAuthorizeService.isAdmin(context, (DSpaceObject)collection)) {
            request.setAttribute("admin_collection", (Object)Boolean.TRUE);
        } else {
            request.setAttribute("admin_collection", (Object)Boolean.FALSE);
        }
        try {
            AuthorizeUtil.authorizeManageAdminGroup((Context)context, (Collection)collection);
            request.setAttribute("admin_create_button", (Object)Boolean.TRUE);
        }
        catch (AuthorizeException authex) {
            request.setAttribute("admin_create_button", (Object)Boolean.FALSE);
        }
        try {
            AuthorizeUtil.authorizeRemoveAdminGroup((Context)context, (Collection)collection);
            request.setAttribute("admin_remove_button", (Object)Boolean.TRUE);
        }
        catch (AuthorizeException authex) {
            request.setAttribute("admin_remove_button", (Object)Boolean.FALSE);
        }
        try {
            AuthorizeUtil.authorizeManageSubmittersGroup((Context)context, (Collection)collection);
            request.setAttribute("submitters_button", (Object)Boolean.TRUE);
        }
        catch (AuthorizeException authex) {
            request.setAttribute("submitters_button", (Object)Boolean.FALSE);
        }
        try {
            AuthorizeUtil.authorizeManageWorkflowsGroup((Context)context, (Collection)collection);
            request.setAttribute("workflows_button", (Object)Boolean.TRUE);
        }
        catch (AuthorizeException authex) {
            request.setAttribute("workflows_button", (Object)Boolean.FALSE);
        }
        try {
            AuthorizeUtil.authorizeManageTemplateItem((Context)context, (Collection)collection);
            request.setAttribute("template_button", (Object)Boolean.TRUE);
        }
        catch (AuthorizeException authex) {
            request.setAttribute("template_button", (Object)Boolean.FALSE);
        }
        if (myAuthorizeService.authorizeActionBoolean(context, collectionService.getParentObject(context, (DSpaceObject)collection), 4)) {
            request.setAttribute("delete_button", (Object)Boolean.TRUE);
        } else {
            request.setAttribute("delete_button", (Object)Boolean.FALSE);
        }
        try {
            AuthorizeUtil.authorizeManageCollectionPolicy((Context)context, (Collection)collection);
            request.setAttribute("policy_button", (Object)Boolean.TRUE);
        }
        catch (AuthorizeException authex) {
            request.setAttribute("policy_button", (Object)Boolean.FALSE);
        }
    }

    private void showControls(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        Community community = (Community)request.getAttribute("community");
        Collection collection = (Collection)request.getAttribute("collection");
        if (collection != null) {
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/handle/" + collection.getHandle()));
        } else if (community != null) {
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/handle/" + community.getHandle()));
        } else {
            Community parent = (Community)request.getAttribute("parent");
            if (parent != null) {
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/handle/" + parent.getHandle()));
            } else {
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/community-list"));
            }
        }
    }

    private void processConfirmEditCommunity(Context context, HttpServletRequest request, HttpServletResponse response, Community community) throws ServletException, IOException, SQLException, AuthorizeException {
        String side;
        String copy;
        if (request.getParameter("create").equals("true")) {
            UUID parentCommunityID = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"parent_community_id");
            if (parentCommunityID != null) {
                Community parent = (Community)this.communityService.find(context, parentCommunityID);
                if (parent != null) {
                    community = this.communityService.createSubcommunity(context, parent);
                }
            } else {
                community = this.communityService.create(null, context);
            }
            request.setAttribute("community", (Object)community);
        }
        this.storeAuthorizeAttributeCommunityEdit(context, request, community);
        this.communityService.setMetadata(context, community, "name", request.getParameter("name"));
        this.communityService.setMetadata(context, community, "short_description", request.getParameter("short_description"));
        String intro = request.getParameter("introductory_text");
        if (intro.equals("")) {
            intro = null;
        }
        if ((copy = request.getParameter("copyright_text")).equals("")) {
            copy = null;
        }
        if ((side = request.getParameter("side_bar_text")).equals("")) {
            side = null;
        }
        this.communityService.setMetadata(context, community, "introductory_text", intro);
        this.communityService.setMetadata(context, community, "copyright_text", copy);
        this.communityService.setMetadata(context, community, "side_bar_text", side);
        this.communityService.update(context, (DSpaceObject)community);
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
        if (button.equals("submit_set_logo")) {
            this.communityService.setLogo(context, community, null);
            this.communityService.update(context, (DSpaceObject)community);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/upload-logo.jsp");
        } else if (button.equals("submit_delete_logo")) {
            this.communityService.setLogo(context, community, null);
            this.communityService.update(context, (DSpaceObject)community);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/edit-community.jsp");
        } else if (button.equals("submit_authorization_edit")) {
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/authorize?community_id=" + community.getID() + "&submit_community_select=1"));
        } else if (button.equals("submit_curate_community")) {
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/curate?community_id=" + community.getID() + "&submit_community_select=1"));
        } else if (button.equals("submit_admins_create")) {
            Group newGroup = this.communityService.createAdministrators(context, community);
            this.communityService.update(context, (DSpaceObject)community);
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/group-edit?group_id=" + newGroup.getID()));
        } else if (button.equals("submit_admins_remove")) {
            Group g = community.getAdministrators();
            this.communityService.removeAdministrators(context, community);
            this.communityService.update(context, (DSpaceObject)community);
            this.groupService.delete(context, (DSpaceObject)g);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/edit-community.jsp");
        } else if (button.equals("submit_admins_edit")) {
            Group g = community.getAdministrators();
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/group-edit?group_id=" + g.getID()));
        } else {
            this.showControls(context, request, response);
        }
        context.complete();
    }

    private void processConfirmEditCollection(Context context, HttpServletRequest request, HttpServletResponse response, Community community, Collection collection) throws ServletException, IOException, SQLException, AuthorizeException {
        Group g;
        Group g2;
        Group newGroup;
        String button;
        String provenance;
        String license;
        String side;
        String copy;
        if (request.getParameter("create").equals("true")) {
            collection = collectionService.create(context, community);
            request.setAttribute("collection", (Object)collection);
        }
        EditCommunitiesServlet.storeAuthorizeAttributeCollectionEdit((Context)context, (HttpServletRequest)request, (Collection)collection);
        collectionService.setMetadata(context, collection, "name", request.getParameter("name"));
        collectionService.setMetadata(context, collection, "short_description", request.getParameter("short_description"));
        String intro = request.getParameter("introductory_text");
        if (intro.equals("")) {
            intro = null;
        }
        if ((copy = request.getParameter("copyright_text")).equals("")) {
            copy = null;
        }
        if ((side = request.getParameter("side_bar_text")).equals("")) {
            side = null;
        }
        if ((license = request.getParameter("license")).equals("")) {
            license = null;
        }
        if ((provenance = request.getParameter("provenance_description")).equals("")) {
            provenance = null;
        }
        collectionService.setMetadata(context, collection, "introductory_text", intro);
        collectionService.setMetadata(context, collection, "copyright_text", copy);
        collectionService.setMetadata(context, collection, "side_bar_text", side);
        collectionService.setMetadata(context, collection, "license", license);
        collectionService.setMetadata(context, collection, "provenance_description", provenance);
        HarvestedCollection hc = this.harvestedCollectionService.find(context, collection);
        String contentSource = request.getParameter("source");
        if (contentSource.equals("source_normal")) {
            if (hc != null) {
                this.harvestedCollectionService.delete(context, hc);
            }
        } else {
            if (hc == null) {
                hc = this.harvestedCollectionService.create(context, collection);
            }
            String oaiProvider = request.getParameter("oai_provider");
            String oaiSetId = request.getParameter("oai_setid");
            String metadataKey = request.getParameter("metadata_format");
            String harvestType = request.getParameter("harvest_level");
            hc.setHarvestParams(Integer.parseInt(harvestType), oaiProvider, oaiSetId, metadataKey);
            hc.setHarvestStatus(0);
            this.harvestedCollectionService.update(context, hc);
        }
        if ((button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit")).equals("submit_set_logo")) {
            collectionService.setLogo(context, collection, null);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/upload-logo.jsp");
        } else if (button.equals("submit_delete_logo")) {
            collectionService.setLogo(context, collection, null);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/edit-collection.jsp");
        } else if (button.startsWith("submit_wf_create_")) {
            int step = Integer.parseInt(button.substring(17));
            Group newGroup2 = collectionService.createWorkflowGroup(context, collection, step);
            collectionService.update(context, (DSpaceObject)collection);
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/group-edit?group_id=" + newGroup2.getID()));
        } else if (button.equals("submit_admins_create")) {
            newGroup = collectionService.createAdministrators(context, collection);
            collectionService.update(context, (DSpaceObject)collection);
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/group-edit?group_id=" + newGroup.getID()));
        } else if (button.equals("submit_admins_delete")) {
            g2 = collection.getAdministrators();
            collectionService.removeAdministrators(context, collection);
            collectionService.update(context, (DSpaceObject)collection);
            this.groupService.delete(context, (DSpaceObject)g2);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/edit-collection.jsp");
        } else if (button.equals("submit_submitters_create")) {
            newGroup = collectionService.createSubmitters(context, collection);
            collectionService.update(context, (DSpaceObject)collection);
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/group-edit?group_id=" + newGroup.getID()));
        } else if (button.equals("submit_submitters_delete")) {
            g2 = collection.getSubmitters();
            collectionService.removeSubmitters(context, collection);
            collectionService.update(context, (DSpaceObject)collection);
            this.groupService.delete(context, (DSpaceObject)g2);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/edit-collection.jsp");
        } else if (button.equals("submit_authorization_edit")) {
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/authorize?collection_id=" + collection.getID() + "&submit_collection_select=1"));
        } else if (button.equals("submit_curate_collection")) {
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/curate?collection_id=" + collection.getID() + "&submit_collection_select=1"));
        } else if (button.startsWith("submit_wf_edit_")) {
            int step = Integer.parseInt(button.substring(15));
            g = collectionService.getWorkflowGroup(collection, step);
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/group-edit?group_id=" + g.getID()));
        } else if (button.equals("submit_submitters_edit")) {
            g2 = collection.getSubmitters();
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/group-edit?group_id=" + g2.getID()));
        } else if (button.equals("submit_admins_edit")) {
            g2 = collection.getAdministrators();
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/group-edit?group_id=" + g2.getID()));
        } else if (button.startsWith("submit_wf_delete_")) {
            int step = Integer.parseInt(button.substring(17));
            g = collectionService.getWorkflowGroup(collection, step);
            collection.setWorkflowGroup(context, step, null);
            collectionService.update(context, (DSpaceObject)collection);
            this.groupService.delete(context, (DSpaceObject)g);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/edit-collection.jsp");
        } else {
            Item i;
            if (button.equals("submit_create_template")) {
                collectionService.createTemplateItem(context, collection);
                i = collection.getTemplateItem();
                collectionService.update(context, (DSpaceObject)collection);
                context.complete();
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/edit-item?item_id=" + i.getID()));
                return;
            }
            if (button.equals("submit_edit_template")) {
                i = collection.getTemplateItem();
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/edit-item?item_id=" + i.getID()));
            } else if (button.equals("submit_delete_template")) {
                collectionService.removeTemplateItem(context, collection);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/edit-collection.jsp");
            } else {
                this.showControls(context, request, response);
            }
        }
        collectionService.update(context, (DSpaceObject)collection);
        context.complete();
    }

    private void processUploadLogo(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        try {
            String jsp;
            Community dso;
            FileUploadRequest wrapper = new FileUploadRequest(request);
            Community community = (Community)this.communityService.find(context, UIUtil.getUUIDParameter((HttpServletRequest)wrapper, (String)"community_id"));
            Collection collection = (Collection)collectionService.find(context, UIUtil.getUUIDParameter((HttpServletRequest)wrapper, (String)"collection_id"));
            File temp = wrapper.getFile("file");
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(temp));
            Bitstream logoBS = collection == null ? this.communityService.setLogo(context, community, (InputStream)is) : collectionService.setLogo(context, collection, (InputStream)is);
            String noPath = wrapper.getFilesystemName("file");
            while (noPath.indexOf(47) > -1) {
                noPath = noPath.substring(noPath.indexOf(47) + 1);
            }
            while (noPath.indexOf(92) > -1) {
                noPath = noPath.substring(noPath.indexOf(92) + 1);
            }
            logoBS.setName(context, noPath);
            logoBS.setSource(context, wrapper.getFilesystemName("file"));
            BitstreamFormat bf = this.bitstreamFormatService.guessFormat(context, logoBS);
            logoBS.setFormat(context, bf);
            myAuthorizeService.addPolicy(context, (DSpaceObject)logoBS, 1, context.getCurrentUser());
            this.bitstreamService.update(context, (DSpaceObject)logoBS);
            if (collection == null) {
                this.communityService.update(context, (DSpaceObject)community);
                request.setAttribute("community", (Object)community);
                this.storeAuthorizeAttributeCommunityEdit(context, request, community);
                dso = community;
                jsp = "/tools/edit-community.jsp";
            } else {
                collectionService.update(context, (DSpaceObject)collection);
                request.setAttribute("collection", (Object)collection);
                request.setAttribute("community", (Object)community);
                EditCommunitiesServlet.storeAuthorizeAttributeCollectionEdit((Context)context, (HttpServletRequest)request, (Collection)collection);
                dso = collection;
                jsp = "/tools/edit-collection.jsp";
            }
            if (myAuthorizeService.isAdmin(context, (DSpaceObject)dso)) {
                request.setAttribute("admin_button", (Object)Boolean.TRUE);
            }
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)jsp);
            if (!temp.delete()) {
                log.error((Object)"Unable to delete temporary file");
            }
            context.complete();
        }
        catch (FileUploadBase.FileSizeLimitExceededException ex) {
            log.warn((Object)"Upload exceeded upload.max");
            JSPManager.showFileSizeLimitExceededError((HttpServletRequest)request, (HttpServletResponse)response, (String)ex.getMessage(), (long)ex.getActualSize(), (long)ex.getPermittedSize());
        }
    }
}

