/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateUtils;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.PolicySet;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;

public class AuthorizeAdminServlet
extends DSpaceServlet {
    private final transient ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private final transient CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private final transient CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    private final transient BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    private final transient BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    private final transient GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    private final transient EPersonService personService = EPersonServiceFactory.getInstance().getEPersonService();
    private final transient HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    private final transient ResourcePolicyService resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();

    protected void doDSGet(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSPost(c, request, response);
    }

    protected void doDSPost(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
        if (button.equals("submit_collection")) {
            List collections = this.collectionService.findAll(c);
            request.setAttribute("collections", (Object)collections);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/collection-select.jsp");
        } else if (button.equals("submit_community")) {
            List communities = this.communityService.findAll(c);
            request.setAttribute("communities", (Object)communities);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/community-select.jsp");
        } else if (button.equals("submit_advanced")) {
            List collections = this.collectionService.findAll(c);
            List groups = this.groupService.findAll(c, null);
            request.setAttribute("collections", (Object)collections);
            request.setAttribute("groups", (Object)groups);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/authorize-advanced.jsp");
        } else if (button.equals("submit_item")) {
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/item-select.jsp");
        } else if (button.equals("submit_item_select")) {
            DSpaceObject dso;
            Item item = null;
            UUID itemId = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"item_id");
            String handle = request.getParameter("handle");
            if (itemId != null) {
                item = (Item)this.itemService.find(c, itemId);
            } else if (handle != null && !handle.equals("") && (dso = this.handleService.resolveToObject(c, handle)) != null && dso.getType() == 2) {
                item = (Item)dso;
            }
            if (item == null) {
                request.setAttribute("invalid.id", (Object)Boolean.TRUE);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/item-select.jsp");
            } else {
                this.prepItemEditForm(c, request, item);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/authorize-item-edit.jsp");
            }
        } else if (button.equals("submit_item_add_policy")) {
            Item item = (Item)this.itemService.find(c, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"item_id"));
            AuthorizeUtil.authorizeManageItemPolicy((Context)c, (Item)item);
            ResourcePolicy policy = this.authorizeService.createResourcePolicy(c, (DSpaceObject)item, this.groupService.findByName(c, "Anonymous"), null, -1, null);
            List groups = this.groupService.findAll(c, null);
            List epeople = this.personService.findAll(c, 1);
            request.setAttribute("edit_title", (Object)("Item " + item.getID()));
            request.setAttribute("policy", (Object)policy);
            request.setAttribute("groups", (Object)groups);
            request.setAttribute("epeople", (Object)epeople);
            request.setAttribute("id_name", (Object)"item_id");
            request.setAttribute("id", (Object)("" + item.getID()));
            request.setAttribute("newpolicy", (Object)"true");
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/authorize-policy-edit.jsp");
        } else if (button.equals("submit_item_edit_policy")) {
            Item item = (Item)this.itemService.find(c, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"item_id"));
            AuthorizeUtil.authorizeManageItemPolicy((Context)c, (Item)item);
            int policyId = UIUtil.getIntParameter((HttpServletRequest)request, (String)"policy_id");
            ResourcePolicy policy = null;
            policy = (ResourcePolicy)this.resourcePolicyService.find(c, policyId);
            List groups = this.groupService.findAll(c, null);
            List epeople = this.personService.findAll(c, 1);
            request.setAttribute("edit_title", (Object)("Item " + item.getID()));
            request.setAttribute("policy", (Object)policy);
            request.setAttribute("groups", (Object)groups);
            request.setAttribute("epeople", (Object)epeople);
            request.setAttribute("id_name", (Object)"item_id");
            request.setAttribute("id", (Object)("" + item.getID()));
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/authorize-policy-edit.jsp");
        } else if (button.equals("submit_bundle_add_policy")) {
            Item item = (Item)this.itemService.find(c, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"item_id"));
            Bundle bundle = (Bundle)this.bundleService.find(c, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"bundle_id"));
            AuthorizeUtil.authorizeManageBundlePolicy((Context)c, (Bundle)bundle);
            ResourcePolicy policy = this.authorizeService.createResourcePolicy(c, (DSpaceObject)bundle, this.groupService.findByName(c, "Anonymous"), null, -1, null);
            List groups = this.groupService.findAll(c, null);
            List epeople = this.personService.findAll(c, 1);
            request.setAttribute("edit_title", (Object)("(Item, Bundle) = (" + item.getID() + "," + bundle.getID() + ")"));
            request.setAttribute("policy", (Object)policy);
            request.setAttribute("groups", (Object)groups);
            request.setAttribute("epeople", (Object)epeople);
            request.setAttribute("id_name", (Object)"item_id");
            request.setAttribute("id", (Object)("" + item.getID()));
            request.setAttribute("newpolicy", (Object)"true");
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/authorize-policy-edit.jsp");
        } else if (button.equals("submit_bitstream_add_policy")) {
            Item item = (Item)this.itemService.find(c, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"item_id"));
            Bitstream bitstream = (Bitstream)this.bitstreamService.find(c, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"bitstream_id"));
            AuthorizeUtil.authorizeManageBitstreamPolicy((Context)c, (Bitstream)bitstream);
            ResourcePolicy policy = this.authorizeService.createResourcePolicy(c, (DSpaceObject)bitstream, this.groupService.findByName(c, "Anonymous"), null, -1, null);
            List groups = this.groupService.findAll(c, null);
            List epeople = this.personService.findAll(c, 1);
            request.setAttribute("edit_title", (Object)("(Item,Bitstream) = (" + item.getID() + "," + bitstream.getID() + ")"));
            request.setAttribute("policy", (Object)policy);
            request.setAttribute("groups", (Object)groups);
            request.setAttribute("epeople", (Object)epeople);
            request.setAttribute("id_name", (Object)"item_id");
            request.setAttribute("id", (Object)("" + item.getID()));
            request.setAttribute("newpolicy", (Object)"true");
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/authorize-policy-edit.jsp");
        } else if (button.equals("submit_item_delete_policy")) {
            ResourcePolicy policy = (ResourcePolicy)this.resourcePolicyService.find(c, UIUtil.getIntParameter((HttpServletRequest)request, (String)"policy_id"));
            Item item = (Item)this.itemService.find(c, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"item_id"));
            AuthorizeUtil.authorizeManageItemPolicy((Context)c, (Item)item);
            this.resourcePolicyService.delete(c, (Object)policy);
            this.prepItemEditForm(c, request, item);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/authorize-item-edit.jsp");
        } else if (button.equals("submit_collection_add_policy")) {
            Collection collection = (Collection)this.collectionService.find(c, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"collection_id"));
            AuthorizeUtil.authorizeManageCollectionPolicy((Context)c, (Collection)collection);
            ResourcePolicy policy = this.authorizeService.createResourcePolicy(c, (DSpaceObject)collection, this.groupService.findByName(c, "Anonymous"), null, -1, null);
            List groups = this.groupService.findAll(c, null);
            List epeople = this.personService.findAll(c, 1);
            request.setAttribute("edit_title", (Object)("Collection " + collection.getID()));
            request.setAttribute("policy", (Object)policy);
            request.setAttribute("groups", (Object)groups);
            request.setAttribute("epeople", (Object)epeople);
            request.setAttribute("id_name", (Object)"collection_id");
            request.setAttribute("id", (Object)("" + collection.getID()));
            request.setAttribute("newpolicy", (Object)"true");
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/authorize-policy-edit.jsp");
        } else if (button.equals("submit_community_select")) {
            Community target = (Community)this.communityService.find(c, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"community_id"));
            List policies = this.authorizeService.getPolicies(c, (DSpaceObject)target);
            request.setAttribute("community", (Object)target);
            request.setAttribute("policies", (Object)policies);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/authorize-community-edit.jsp");
        } else if (button.equals("submit_collection_delete_policy")) {
            Collection collection = (Collection)this.collectionService.find(c, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"collection_id"));
            AuthorizeUtil.authorizeManageCollectionPolicy((Context)c, (Collection)collection);
            ResourcePolicy policy = (ResourcePolicy)this.resourcePolicyService.find(c, UIUtil.getIntParameter((HttpServletRequest)request, (String)"policy_id"));
            this.resourcePolicyService.delete(c, (Object)policy);
            request.setAttribute("collection", (Object)collection);
            List policies = this.authorizeService.getPolicies(c, (DSpaceObject)collection);
            request.setAttribute("policies", (Object)policies);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/authorize-collection-edit.jsp");
        } else if (button.equals("submit_community_delete_policy")) {
            Community community = (Community)this.communityService.find(c, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"community_id"));
            AuthorizeUtil.authorizeManageCommunityPolicy((Context)c, (Community)community);
            ResourcePolicy policy = (ResourcePolicy)this.resourcePolicyService.find(c, UIUtil.getIntParameter((HttpServletRequest)request, (String)"policy_id"));
            this.resourcePolicyService.delete(c, (Object)policy);
            request.setAttribute("community", (Object)community);
            List policies = this.authorizeService.getPolicies(c, (DSpaceObject)community);
            request.setAttribute("policies", (Object)policies);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/authorize-community-edit.jsp");
        } else if (button.equals("submit_collection_edit_policy")) {
            Collection collection = (Collection)this.collectionService.find(c, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"collection_id"));
            AuthorizeUtil.authorizeManageCollectionPolicy((Context)c, (Collection)collection);
            int policyId = UIUtil.getIntParameter((HttpServletRequest)request, (String)"policy_id");
            ResourcePolicy policy = null;
            policy = policyId == -1 ? this.authorizeService.createResourcePolicy(c, (DSpaceObject)collection, this.groupService.findByName(c, "Anonymous"), null, -1, null) : (ResourcePolicy)this.resourcePolicyService.find(c, policyId);
            List groups = this.groupService.findAll(c, null);
            List epeople = this.personService.findAll(c, 1);
            request.setAttribute("edit_title", (Object)("Collection " + collection.getID()));
            request.setAttribute("policy", (Object)policy);
            request.setAttribute("groups", (Object)groups);
            request.setAttribute("epeople", (Object)epeople);
            request.setAttribute("id_name", (Object)"collection_id");
            request.setAttribute("id", (Object)("" + collection.getID()));
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/authorize-policy-edit.jsp");
        } else if (button.equals("submit_community_edit_policy")) {
            Community community = (Community)this.communityService.find(c, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"community_id"));
            AuthorizeUtil.authorizeManageCommunityPolicy((Context)c, (Community)community);
            int policyId = UIUtil.getIntParameter((HttpServletRequest)request, (String)"policy_id");
            ResourcePolicy policy = null;
            policy = policyId == -1 ? this.authorizeService.createResourcePolicy(c, (DSpaceObject)community, this.groupService.findByName(c, "Anonymous"), null, -1, null) : (ResourcePolicy)this.resourcePolicyService.find(c, policyId);
            List groups = this.groupService.findAll(c, null);
            List epeople = this.personService.findAll(c, 1);
            request.setAttribute("edit_title", (Object)("Community " + community.getID()));
            request.setAttribute("policy", (Object)policy);
            request.setAttribute("groups", (Object)groups);
            request.setAttribute("epeople", (Object)epeople);
            request.setAttribute("id_name", (Object)"community_id");
            request.setAttribute("id", (Object)("" + community.getID()));
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/authorize-policy-edit.jsp");
        } else if (button.equals("submit_collection_add_policy")) {
            Collection collection = (Collection)this.collectionService.find(c, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"collection_id"));
            AuthorizeUtil.authorizeManageCollectionPolicy((Context)c, (Collection)collection);
            ResourcePolicy policy = this.authorizeService.createResourcePolicy(c, (DSpaceObject)collection, this.groupService.findByName(c, "Anonymous"), null, -1, null);
            List groups = this.groupService.findAll(c, null);
            List epeople = this.personService.findAll(c, 1);
            request.setAttribute("edit_title", (Object)("Collection " + collection.getID()));
            request.setAttribute("policy", (Object)policy);
            request.setAttribute("groups", (Object)groups);
            request.setAttribute("epeople", (Object)epeople);
            request.setAttribute("id_name", (Object)"collection_id");
            request.setAttribute("id", (Object)("" + collection.getID()));
            request.setAttribute("newpolicy", (Object)"true");
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/authorize-policy-edit.jsp");
        } else if (button.equals("submit_community_add_policy")) {
            Community community = (Community)this.communityService.find(c, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"community_id"));
            AuthorizeUtil.authorizeManageCommunityPolicy((Context)c, (Community)community);
            ResourcePolicy policy = this.authorizeService.createResourcePolicy(c, (DSpaceObject)community, this.groupService.findByName(c, "Anonymous"), null, -1, null);
            List groups = this.groupService.findAll(c, null);
            List epeople = this.personService.findAll(c, 1);
            request.setAttribute("edit_title", (Object)("Community " + community.getID()));
            request.setAttribute("policy", (Object)policy);
            request.setAttribute("groups", (Object)groups);
            request.setAttribute("epeople", (Object)epeople);
            request.setAttribute("id_name", (Object)"community_id");
            request.setAttribute("id", (Object)("" + community.getID()));
            request.setAttribute("newpolicy", (Object)"true");
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/authorize-policy-edit.jsp");
        } else if (button.equals("submit_save_policy")) {
            int policyId = UIUtil.getIntParameter((HttpServletRequest)request, (String)"policy_id");
            int actionId = UIUtil.getIntParameter((HttpServletRequest)request, (String)"action_id");
            UUID groupId = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"group_id");
            UUID collectionId = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"collection_id");
            UUID communityId = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"community_id");
            UUID itemId = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"item_id");
            Date startDate = null;
            try {
                startDate = DateUtils.parseDate((String)request.getParameter("policy_start_date"), (String[])new String[]{"yyyy-MM-dd", "yyyy-MM", "yyyy"});
            }
            catch (Exception exception) {
                // empty catch block
            }
            Date endDate = null;
            try {
                endDate = DateUtils.parseDate((String)request.getParameter("policy_end_date"), (String[])new String[]{"yyyy-MM-dd", "yyyy-MM", "yyyy"});
            }
            catch (Exception exception) {
                // empty catch block
            }
            Item item = null;
            Collection collection = null;
            Community community = null;
            String displayPage = null;
            ResourcePolicy policy = (ResourcePolicy)this.resourcePolicyService.find(c, policyId);
            AuthorizeUtil.authorizeManagePolicy((Context)c, (ResourcePolicy)policy);
            Group group = (Group)this.groupService.find(c, groupId);
            if (collectionId != null) {
                collection = (Collection)this.collectionService.find(c, collectionId);
                policy.setAction(actionId);
                policy.setGroup(group);
                this.resourcePolicyService.update(c, (Object)policy);
                if (actionId == 0) {
                    List rps = this.authorizeService.getPoliciesActionFilter(c, (DSpaceObject)collection, 0);
                    Bitstream bs = collection.getLogo();
                    if (bs != null) {
                        this.authorizeService.removeAllPolicies(c, (DSpaceObject)bs);
                        this.authorizeService.addPolicies(c, rps, (DSpaceObject)bs);
                    }
                }
                request.setAttribute("collection", (Object)collection);
                request.setAttribute("policies", (Object)this.authorizeService.getPolicies(c, (DSpaceObject)collection));
                displayPage = "/dspace-admin/authorize-collection-edit.jsp";
            } else if (communityId != null) {
                community = (Community)this.communityService.find(c, communityId);
                policy.setAction(actionId);
                policy.setGroup(group);
                this.resourcePolicyService.update(c, (Object)policy);
                if (actionId == 0) {
                    List rps = this.authorizeService.getPoliciesActionFilter(c, (DSpaceObject)community, 0);
                    Bitstream bs = community.getLogo();
                    if (bs != null) {
                        this.authorizeService.removeAllPolicies(c, (DSpaceObject)bs);
                        this.authorizeService.addPolicies(c, rps, (DSpaceObject)bs);
                    }
                }
                request.setAttribute("community", (Object)community);
                request.setAttribute("policies", (Object)this.authorizeService.getPolicies(c, (DSpaceObject)community));
                displayPage = "/dspace-admin/authorize-community-edit.jsp";
            } else if (itemId != null) {
                item = (Item)this.itemService.find(c, itemId);
                policy.setAction(actionId);
                policy.setGroup(group);
                policy.setStartDate(startDate);
                policy.setEndDate(endDate);
                this.resourcePolicyService.update(c, (Object)policy);
                this.prepItemEditForm(c, request, item);
                displayPage = "/dspace-admin/authorize-item-edit.jsp";
            }
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, displayPage);
        } else if (button.equals("submit_cancel_policy")) {
            if (request.getParameter("newpolicy") != null) {
                int policyId = UIUtil.getIntParameter((HttpServletRequest)request, (String)"policy_id");
                ResourcePolicy rp = (ResourcePolicy)this.resourcePolicyService.find(c, policyId);
                AuthorizeUtil.authorizeManagePolicy((Context)c, (ResourcePolicy)rp);
                this.resourcePolicyService.delete(c, (Object)rp);
            }
            UUID collectionId = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"collection_id");
            UUID communityId = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"community_id");
            UUID itemId = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"item_id");
            String displayPage = null;
            if (collectionId != null) {
                Collection t = (Collection)this.collectionService.find(c, collectionId);
                request.setAttribute("collection", (Object)t);
                request.setAttribute("policies", (Object)this.authorizeService.getPolicies(c, (DSpaceObject)t));
                displayPage = "/dspace-admin/authorize-collection-edit.jsp";
            } else if (communityId != null) {
                Community t = (Community)this.communityService.find(c, communityId);
                request.setAttribute("community", (Object)t);
                request.setAttribute("policies", (Object)this.authorizeService.getPolicies(c, (DSpaceObject)t));
                displayPage = "/dspace-admin/authorize-community-edit.jsp";
            } else if (itemId != null) {
                Item t = (Item)this.itemService.find(c, itemId);
                this.prepItemEditForm(c, request, t);
                displayPage = "/dspace-admin/authorize-item-edit.jsp";
            }
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, displayPage);
        } else if (button.equals("submit_advanced_clear")) {
            AuthorizeUtil.requireAdminRole((Context)c);
            UUID collectionId = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"collection_id");
            int resourceType = UIUtil.getIntParameter((HttpServletRequest)request, (String)"resource_type");
            PolicySet.setPolicies((Context)c, (int)3, (UUID)collectionId, (int)resourceType, (int)0, (UUID)this.groupService.findByName(c, "Anonymous").getID(), (boolean)false, (boolean)true);
            if (resourceType == 0) {
                PolicySet.setPolicies((Context)c, (int)3, (UUID)collectionId, (int)1, (int)0, (UUID)this.groupService.findByName(c, "Anonymous").getID(), (boolean)false, (boolean)true);
            }
            this.showMainPage(c, request, response);
        } else if (button.equals("submit_advanced_add")) {
            AuthorizeUtil.requireAdminRole((Context)c);
            UUID collectionId = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"collection_id");
            int resourceType = UIUtil.getIntParameter((HttpServletRequest)request, (String)"resource_type");
            int actionId = UIUtil.getIntParameter((HttpServletRequest)request, (String)"action_id");
            UUID groupId = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"group_id");
            PolicySet.setPolicies((Context)c, (int)3, (UUID)collectionId, (int)resourceType, (int)actionId, (UUID)groupId, (boolean)false, (boolean)false);
            if (resourceType == 0) {
                PolicySet.setPolicies((Context)c, (int)3, (UUID)collectionId, (int)1, (int)actionId, (UUID)groupId, (boolean)false, (boolean)false);
            }
            this.showMainPage(c, request, response);
        } else if (button.equals("submit_collection_select")) {
            Collection collection = (Collection)this.collectionService.find(c, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"collection_id"));
            List policies = this.authorizeService.getPolicies(c, (DSpaceObject)collection);
            request.setAttribute("collection", (Object)collection);
            request.setAttribute("policies", (Object)policies);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/authorize-collection-edit.jsp");
        } else {
            this.showMainPage(c, request, response);
        }
        c.complete();
    }

    void showMainPage(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/authorize-main.jsp");
    }

    void prepItemEditForm(Context c, HttpServletRequest request, Item item) throws SQLException {
        List itemPolicies = this.authorizeService.getPolicies(c, (DSpaceObject)item);
        HashMap<UUID, List> bundlePolicies = new HashMap<UUID, List>();
        HashMap<UUID, List> bitstreamPolicies = new HashMap<UUID, List>();
        List bundles = item.getBundles();
        for (Bundle myBundle : bundles) {
            List myPolicies = this.authorizeService.getPolicies(c, (DSpaceObject)myBundle);
            bundlePolicies.put(myBundle.getID(), myPolicies);
            List bitstreams = myBundle.getBitstreams();
            for (Bitstream myBitstream : bitstreams) {
                myPolicies = this.authorizeService.getPolicies(c, (DSpaceObject)myBitstream);
                bitstreamPolicies.put(myBitstream.getID(), myPolicies);
            }
        }
        request.setAttribute("item", (Object)item);
        request.setAttribute("item_policies", (Object)itemPolicies);
        request.setAttribute("bundles", (Object)bundles);
        request.setAttribute("bundle_policies", bundlePolicies);
        request.setAttribute("bitstream_policies", bitstreamPolicies);
    }
}

