/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;
import org.dspace.usage.UsageSearchEvent;

public class SearchResultLogServlet
extends DSpaceServlet {
    private final transient HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String redirectUrl = request.getParameter("redirectUrl");
        String scopeHandle = request.getParameter("scope");
        DSpaceObject scope = this.handleService.resolveToObject(context, scopeHandle);
        String resultHandle = StringUtils.substringAfter((String)redirectUrl, (String)"/handle/");
        DSpaceObject result = this.handleService.resolveToObject(context, resultHandle);
        UsageSearchEvent searchEvent = new UsageSearchEvent(UsageEvent.Action.SEARCH, request, context, result, Arrays.asList(request.getParameterValues("query")), scope);
        if (!StringUtils.isBlank((String)request.getParameter("rpp"))) {
            searchEvent.setRpp(Integer.parseInt(request.getParameter("rpp")));
        }
        if (!StringUtils.isBlank((String)request.getParameter("sort_by"))) {
            searchEvent.setSortBy(request.getParameter("sort_by"));
        }
        if (!StringUtils.isBlank((String)request.getParameter("order"))) {
            searchEvent.setSortOrder(request.getParameter("order"));
        }
        if (!StringUtils.isBlank((String)request.getParameter("page"))) {
            searchEvent.setPage(Integer.parseInt(request.getParameter("page")));
        }
        DSpaceServicesFactory.getInstance().getEventService().fireEvent((Event)searchEvent);
        response.sendRedirect(redirectUrl);
    }
}

