/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.itemexport.ItemExportException;
import org.dspace.app.itemexport.factory.ItemExportServiceFactory;
import org.dspace.app.itemexport.service.ItemExportService;
import org.dspace.app.itemimport.BTEBatchImportService;
import org.dspace.app.itemimport.factory.ItemImportServiceFactory;
import org.dspace.app.itemimport.service.ItemImportService;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReader;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.SupervisedItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.utils.DSpace;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflowbasic.BasicWorkflowItem;
import org.dspace.workflowbasic.factory.BasicWorkflowServiceFactory;
import org.dspace.workflowbasic.service.BasicWorkflowItemService;
import org.dspace.workflowbasic.service.BasicWorkflowService;

public class MyDSpaceServlet
extends DSpaceServlet {
    private static final Logger log = Logger.getLogger(MyDSpaceServlet.class);
    public static final int MAIN_PAGE = 0;
    public static final int REMOVE_ITEM_PAGE = 1;
    public static final int PREVIEW_TASK_PAGE = 2;
    public static final int PERFORM_TASK_PAGE = 3;
    public static final int REJECT_REASON_PAGE = 4;
    public static final int REQUEST_EXPORT_ARCHIVE = 5;
    public static final int REQUEST_MIGRATE_ARCHIVE = 6;
    public static final int REQUEST_BATCH_IMPORT_ACTION = 7;
    private final transient WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    private final transient BasicWorkflowService workflowService = BasicWorkflowServiceFactory.getInstance().getBasicWorkflowService();
    private final transient BasicWorkflowItemService workflowItemService = BasicWorkflowServiceFactory.getInstance().getBasicWorkflowItemService();
    private final transient HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    private final transient ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private final transient ItemExportService itemExportService = ItemExportServiceFactory.getInstance().getItemExportService();
    private final transient ItemImportService itemImportService = ItemImportServiceFactory.getInstance().getItemImportService();
    private final transient CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private final transient CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    private final transient GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    private final transient SupervisedItemService supervisedItemService = ContentServiceFactory.getInstance().getSupervisedItemService();

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        Context.Mode originalMode = context.getCurrentMode();
        context.setMode(Context.Mode.READ_ONLY);
        this.showMainPage(context, request, response);
        context.setMode(originalMode);
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        int step = UIUtil.getIntParameter((HttpServletRequest)request, (String)"step");
        switch (step) {
            case 0: {
                this.processMainPage(context, request, response);
                break;
            }
            case 1: {
                this.processRemoveItem(context, request, response);
                break;
            }
            case 2: {
                this.processPreviewTask(context, request, response);
                break;
            }
            case 3: {
                this.processPerformTask(context, request, response);
                break;
            }
            case 4: {
                this.processRejectReason(context, request, response);
                break;
            }
            case 5: {
                this.processExportArchive(context, request, response, false);
                break;
            }
            case 6: {
                this.processExportArchive(context, request, response, true);
                break;
            }
            case 7: {
                this.processBatchImportAction(context, request, response);
                break;
            }
            default: {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
    }

    protected void processMainPage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        BasicWorkflowItem workflowItem;
        WorkspaceItem workspaceItem;
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_own");
        try {
            int wsID = Integer.parseInt(request.getParameter("workspace_id"));
            workspaceItem = this.workspaceItemService.find(context, wsID);
        }
        catch (NumberFormatException nfe) {
            workspaceItem = null;
        }
        try {
            int wfID = Integer.parseInt(request.getParameter("workflow_id"));
            workflowItem = (BasicWorkflowItem)this.workflowItemService.find(context, wfID);
        }
        catch (NumberFormatException nfe) {
            workflowItem = null;
        }
        boolean ok = false;
        if (buttonPressed.equals("submit_new")) {
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/submit"));
            ok = true;
        } else if (buttonPressed.equals("submit_own")) {
            this.showPreviousSubmissions(context, request, response);
            ok = true;
        } else if (buttonPressed.equals("submit_resume")) {
            String wsID = request.getParameter("workspace_id");
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/submit?resume=" + wsID));
            ok = true;
        } else if (buttonPressed.equals("submit_delete")) {
            if (workspaceItem != null) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"confirm_removal", (String)("workspace_item_id=" + workspaceItem.getID())));
                request.setAttribute("workspace.item", (Object)workspaceItem);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/remove-item.jsp");
            } else {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
            }
            ok = true;
        } else if (buttonPressed.equals("submit_claim")) {
            if (workflowItem != null) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"view_workflow", (String)("workflow_id=" + workflowItem.getID())));
                request.setAttribute("workflow.item", (Object)workflowItem);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/preview-task.jsp");
                ok = true;
            }
        } else if (buttonPressed.equals("submit_perform")) {
            if (workflowItem != null) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"view_workflow", (String)("workflow_id=" + workflowItem.getID())));
                request.setAttribute("workflow.item", (Object)workflowItem);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/perform-task.jsp");
                ok = true;
            }
        } else if (buttonPressed.equals("submit_return") && workflowItem != null) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"unclaim_workflow", (String)("workflow_id=" + workflowItem.getID())));
            this.workflowService.unclaim(context, workflowItem, context.getCurrentUser());
            this.showMainPage(context, request, response);
            context.complete();
            ok = true;
        }
        if (!ok) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
            JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    private void processRemoveItem(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        WorkspaceItem workspaceItem;
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_cancel");
        try {
            int wsID = Integer.parseInt(request.getParameter("workspace_id"));
            workspaceItem = this.workspaceItemService.find(context, wsID);
        }
        catch (NumberFormatException nfe) {
            workspaceItem = null;
        }
        if (workspaceItem == null) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
            JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        if (buttonPressed.equals("submit_delete")) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"remove_submission", (String)("workspace_item_id=" + workspaceItem.getID() + ",item_id=" + workspaceItem.getItem().getID())));
            this.workspaceItemService.deleteAll(context, workspaceItem);
            this.showMainPage(context, request, response);
            context.complete();
        } else {
            this.showMainPage(context, request, response);
        }
    }

    private void processPreviewTask(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        BasicWorkflowItem workflowItem;
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_cancel");
        try {
            int wfID = Integer.parseInt(request.getParameter("workflow_id"));
            workflowItem = (BasicWorkflowItem)this.workflowItemService.find(context, wfID);
        }
        catch (NumberFormatException nfe) {
            workflowItem = null;
        }
        if (workflowItem == null) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
            JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        if (buttonPressed.equals("submit_start")) {
            this.workflowService.claim(context, workflowItem, context.getCurrentUser());
            request.setAttribute("workflow.item", (Object)workflowItem);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/perform-task.jsp");
            context.complete();
        } else {
            this.showMainPage(context, request, response);
        }
    }

    private void processPerformTask(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        BasicWorkflowItem workflowItem;
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_cancel");
        try {
            int wfID = Integer.parseInt(request.getParameter("workflow_id"));
            workflowItem = (BasicWorkflowItem)this.workflowItemService.find(context, wfID);
        }
        catch (NumberFormatException nfe) {
            workflowItem = null;
        }
        if (workflowItem == null) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
            JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        if (buttonPressed.equals("submit_approve")) {
            Item item = workflowItem.getItem();
            this.workflowService.advance(context, workflowItem, context.getCurrentUser());
            String handle = this.handleService.findHandle(context, (DSpaceObject)item);
            if (handle != null) {
                String displayHandle = this.handleService.getCanonicalForm(handle);
                request.setAttribute("handle", (Object)displayHandle);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/in-archive.jsp");
            } else {
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/task-complete.jsp");
            }
            context.complete();
        } else if (buttonPressed.equals("submit_reject")) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"get_reject_reason", (String)("workflow_id=" + workflowItem.getID() + ",item_id=" + workflowItem.getItem().getID())));
            request.setAttribute("workflow.item", (Object)workflowItem);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/reject-reason.jsp");
        } else if (buttonPressed.equals("submit_edit")) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"edit_workflow_item", (String)("workflow_id=" + workflowItem.getID() + ",item_id=" + workflowItem.getItem().getID())));
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/submit?workflow=" + workflowItem.getID()));
        } else if (buttonPressed.equals("submit_pool")) {
            this.workflowService.unclaim(context, workflowItem, context.getCurrentUser());
            this.showMainPage(context, request, response);
            context.complete();
        } else {
            this.showMainPage(context, request, response);
        }
    }

    private void processRejectReason(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        BasicWorkflowItem workflowItem;
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_cancel");
        try {
            int wfID = Integer.parseInt(request.getParameter("workflow_id"));
            workflowItem = (BasicWorkflowItem)this.workflowItemService.find(context, wfID);
        }
        catch (NumberFormatException nfe) {
            workflowItem = null;
        }
        if (workflowItem == null) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
            JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        if (buttonPressed.equals("submit_send")) {
            String reason = request.getParameter("reason");
            WorkspaceItem wsi = this.workflowService.sendWorkflowItemBackSubmission(context, (WorkflowItem)workflowItem, context.getCurrentUser(), null, reason);
            Collection c = wsi.getCollection();
            SubmissionConfigReader subConfigReader = new SubmissionConfigReader();
            SubmissionConfig subConfig = subConfigReader.getSubmissionConfig(c.getHandle(), false);
            int lastStep = subConfig.getNumberOfSteps() - 2;
            wsi.setStageReached(lastStep);
            wsi.setPageReached(Integer.MAX_VALUE);
            this.workspaceItemService.update(context, (InProgressSubmission)wsi);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/task-complete.jsp");
            context.complete();
        } else {
            request.setAttribute("workflow.item", (Object)workflowItem);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/perform-task.jsp");
        }
    }

    private void processExportArchive(Context context, HttpServletRequest request, HttpServletResponse response, boolean migrate) throws ServletException, IOException {
        if (request.getParameter("item_id") != null) {
            Item item = null;
            try {
                item = (Item)this.itemService.find(context, UUID.fromString(request.getParameter("item_id")));
            }
            catch (Exception e) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            if (item == null) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            try {
                this.itemExportService.createDownloadableExport((DSpaceObject)item, context, migrate);
            }
            catch (ItemExportException iee) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"export_too_large_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/export-error.jsp");
                return;
            }
            catch (Exception e) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/task-complete.jsp");
        } else if (request.getParameter("collection_id") != null) {
            Collection col = null;
            try {
                col = (Collection)this.collectionService.find(context, UUID.fromString(request.getParameter("collection_id")));
            }
            catch (Exception e) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            if (col == null) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            try {
                this.itemExportService.createDownloadableExport((DSpaceObject)col, context, migrate);
            }
            catch (ItemExportException iee) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"export_too_large_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/export-error.jsp");
                return;
            }
            catch (Exception e) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/task-complete.jsp");
        } else if (request.getParameter("community_id") != null) {
            Community com = null;
            try {
                com = (Community)this.communityService.find(context, UUID.fromString(request.getParameter("community_id")));
            }
            catch (Exception e) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            if (com == null) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            try {
                this.itemExportService.createDownloadableExport((DSpaceObject)com, context, migrate);
            }
            catch (ItemExportException iee) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"export_too_large_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/export-error.jsp");
                return;
            }
            catch (Exception e) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/task-complete.jsp");
        }
    }

    private void processBatchImportAction(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_mapfile");
        String uploadId = request.getParameter("uploadid");
        if (buttonPressed.equals("submit_mapfile")) {
            String mapFilePath = null;
            try {
                mapFilePath = this.itemImportService.getImportUploadableDirectory(context.getCurrentUser()) + File.separator + uploadId + File.separator + "mapfile";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showMainPage(context, request, response);
                return;
            }
            File file = new File(mapFilePath);
            int length = 0;
            ServletOutputStream outStream = response.getOutputStream();
            String mimetype = "application/octet-stream";
            response.setContentType(mimetype);
            response.setContentLength((int)file.length());
            String fileName = file.getName();
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            byte[] byteBuffer = new byte[1024];
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            while (in != null && (length = in.read(byteBuffer)) != -1) {
                outStream.write(byteBuffer, 0, length);
            }
            in.close();
            outStream.close();
        } else if (buttonPressed.equals("submit_delete")) {
            try {
                this.itemImportService.deleteBatchUpload(context, uploadId);
                this.showMainPage(context, request, response);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (buttonPressed.equals("submit_resume")) {
            request.setAttribute("uploadId", (Object)uploadId);
            List collections = this.collectionService.findAll(context);
            request.setAttribute("collections", (Object)collections);
            BTEBatchImportService dls = (BTEBatchImportService)new DSpace().getSingletonService(BTEBatchImportService.class);
            List inputTypes = dls.getFileDataLoaders();
            request.setAttribute("input-types", (Object)inputTypes);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/batchimport.jsp");
        } else {
            this.showMainPage(context, request, response);
        }
    }

    private void showMainPage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        log.info((Object)LogManager.getHeader((Context)context, (String)"view_mydspace", (String)""));
        EPerson currentUser = context.getCurrentUser();
        List ownedList = this.workflowService.getOwnedTasks(context, currentUser);
        List pooledList = this.workflowService.getPooledTasks(context, currentUser);
        List workflowItems = this.workflowItemService.findBySubmitter(context, currentUser);
        List workspaceItems = this.workspaceItemService.findByEPerson(context, currentUser);
        List memberships = this.groupService.allMemberGroups(context, currentUser);
        boolean displayMemberships = ConfigurationManager.getBooleanProperty((String)"webui.mydspace.showgroupmemberships", (boolean)false);
        List supervisedItems = this.supervisedItemService.findbyEPerson(context, currentUser);
        List exportArchives = null;
        try {
            exportArchives = this.itemExportService.getExportsAvailable(currentUser);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List importUploads = null;
        try {
            importUploads = this.itemImportService.getImportsAvailable(currentUser);
        }
        catch (Exception exception) {
            // empty catch block
        }
        request.setAttribute("mydspace.user", (Object)currentUser);
        request.setAttribute("workspace.items", (Object)workspaceItems);
        request.setAttribute("workflow.items", (Object)workflowItems);
        request.setAttribute("workflow.owned", (Object)ownedList);
        request.setAttribute("workflow.pooled", (Object)pooledList);
        request.setAttribute("group.memberships", (Object)memberships);
        request.setAttribute("display.groupmemberships", (Object)displayMemberships);
        request.setAttribute("supervised.items", (Object)supervisedItems);
        request.setAttribute("export.archives", (Object)exportArchives);
        request.setAttribute("import.uploads", (Object)importUploads);
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/main.jsp");
    }

    private void showPreviousSubmissions(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        LinkedList subList = new LinkedList();
        Iterator subs = this.itemService.findBySubmitter(context, context.getCurrentUser());
        while (subs.hasNext()) {
            subList.add(subs.next());
        }
        log.info((Object)LogManager.getHeader((Context)context, (String)"view_own_submissions", (String)("count=" + subList.size())));
        request.setAttribute("user", (Object)context.getCurrentUser());
        request.setAttribute("items", subList);
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/own-submissions.jsp");
    }
}

