/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.itemexport.factory.ItemExportServiceFactory;
import org.dspace.app.itemexport.service.ItemExportService;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.Utils;

public class ItemExportArchiveServlet
extends DSpaceServlet {
    private static final Logger log = Logger.getLogger(ItemExportArchiveServlet.class);
    private final transient ItemExportService itemExportService = ItemExportServiceFactory.getInstance().getItemExportService();

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String filename = null;
        filename = request.getPathInfo().substring(request.getPathInfo().lastIndexOf(47) + 1);
        log.debug((Object)filename);
        if (this.itemExportService.canDownload(context, filename)) {
            try {
                InputStream exportStream = this.itemExportService.getExportDownloadInputStream(filename, context.getCurrentUser());
                if (exportStream == null || filename == null) {
                    log.info((Object)LogManager.getHeader((Context)context, (String)"invalid_id", (String)("path=" + filename)));
                    JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)filename, (int)0);
                    return;
                }
                log.info((Object)LogManager.getHeader((Context)context, (String)"download_export_archive", (String)("filename=" + filename)));
                long lastModified = this.itemExportService.getExportFileLastModified(context, filename);
                response.setDateHeader("Last-Modified", lastModified);
                long modSince = request.getDateHeader("If-Modified-Since");
                if (modSince != -1L && lastModified < modSince) {
                    response.setStatus(304);
                    return;
                }
                response.setContentType("application/zip");
                long size = this.itemExportService.getExportFileSize(context, filename);
                response.setHeader("Content-Length", String.valueOf(size));
                response.setHeader("Content-Disposition", "attachment;filename=" + filename);
                Utils.bufferedCopy((InputStream)exportStream, (OutputStream)response.getOutputStream());
                exportStream.close();
                response.getOutputStream().flush();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            throw new AuthorizeException("You are not authorized to download this Export Archive.");
        }
    }
}

