/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.discovery;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.app.bulkedit.MetadataExport;
import org.dspace.app.util.SyndicationFeed;
import org.dspace.app.util.factory.UtilServiceFactory;
import org.dspace.app.util.service.OpenSearchService;
import org.dspace.app.webui.discovery.DiscoverUtility;
import org.dspace.app.webui.search.SearchProcessorException;
import org.dspace.app.webui.search.SearchRequestProcessor;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilter;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;
import org.w3c.dom.Document;

public class DiscoverySearchRequestProcessor
implements SearchRequestProcessor {
    private static final int ITEMMAP_RESULT_PAGE_SIZE = 50;
    private static String msgKey = "org.dspace.app.webui.servlet.FeedServlet";
    private static Logger log = Logger.getLogger(DiscoverySearchRequestProcessor.class);
    private Map<String, Map<String, String>> localeLabels = null;
    private List<String> searchIndices = null;
    private OpenSearchService openSearchService;
    private CommunityService communityService;
    private CollectionService collectionService;
    private AuthorizeService authorizeService;

    public synchronized void init() {
        if (this.localeLabels == null) {
            this.localeLabels = new HashMap();
        }
        if (this.searchIndices == null) {
            this.searchIndices = new ArrayList();
            DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration();
            this.searchIndices.add("any");
            for (DiscoverySearchFilter sFilter : discoveryConfiguration.getSearchFilters()) {
                this.searchIndices.add(sFilter.getIndexFieldName());
            }
        }
        this.openSearchService = UtilServiceFactory.getInstance().getOpenSearchService();
        this.communityService = ContentServiceFactory.getInstance().getCommunityService();
        this.collectionService = ContentServiceFactory.getInstance().getCollectionService();
        this.authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    }

    public void doOpenSearch(Context context, HttpServletRequest request, HttpServletResponse response) throws SearchProcessorException, IOException, ServletException {
        DSpaceObject container;
        String path;
        this.init();
        String scope = request.getParameter("scope");
        if (scope != null && "".equals(scope)) {
            scope = null;
        }
        if ((path = request.getPathInfo()) != null && path.endsWith("description.xml")) {
            String svcDescrip = this.openSearchService.getDescription(scope);
            response.setContentType(this.openSearchService.getContentType("opensearchdescription"));
            response.setContentLength(svcDescrip.length());
            response.getWriter().write(svcDescrip);
            return;
        }
        String format = request.getParameter("format");
        if (format == null || "".equals(format)) {
            format = "atom";
        }
        if (!this.openSearchService.getFormats().contains(format)) {
            response.sendError(400);
            return;
        }
        try {
            container = DiscoverUtility.getSearchScope((Context)context, (HttpServletRequest)request);
        }
        catch (Exception e) {
            throw new SearchProcessorException(e.getMessage(), (Throwable)e);
        }
        DiscoverQuery queryArgs = DiscoverUtility.getDiscoverQuery((Context)context, (HttpServletRequest)request, (DSpaceObject)container, (boolean)false);
        String query = request.getParameter("query");
        DiscoverResult qResults = null;
        try {
            qResults = SearchUtils.getSearchService().search(context, container, queryArgs);
        }
        catch (SearchServiceException e) {
            log.error((Object)LogManager.getHeader((Context)context, (String)"opensearch", (String)("query=" + queryArgs.getQuery() + ",scope=" + scope + ",error=" + e.getMessage())), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        log.info((Object)LogManager.getHeader((Context)context, (String)"opensearch", (String)("scope=" + scope + ",query=\"" + query + "\",results=(" + qResults.getTotalSearchResults() + ")")));
        Map labelMap = this.getLabels(request);
        List dsoResults = qResults.getDspaceObjects();
        Document resultsDoc = this.openSearchService.getResultsDoc(context, format, query, (int)qResults.getTotalSearchResults(), qResults.getStart(), qResults.getMaxResults(), container, dsoResults, labelMap);
        try {
            Transformer xf = TransformerFactory.newInstance().newTransformer();
            response.setContentType(this.openSearchService.getContentType(format));
            xf.transform(new DOMSource(resultsDoc), new StreamResult(response.getWriter()));
        }
        catch (TransformerException e) {
            log.error((Object)e);
            throw new ServletException(e.toString());
        }
    }

    private Map<String, String> getLabels(HttpServletRequest request) {
        Locale locale = UIUtil.getSessionLocale((HttpServletRequest)request);
        Map labelMap = (Map)this.localeLabels.get(locale.toString());
        if (labelMap == null) {
            labelMap = this.getLocaleLabels(locale);
            this.localeLabels.put(locale.toString(), labelMap);
        }
        return labelMap;
    }

    private Map<String, String> getLocaleLabels(Locale locale) {
        HashMap<String, String> labelMap = new HashMap<String, String>();
        labelMap.put("notitle", I18nUtil.getMessage((String)(msgKey + ".notitle"), (Locale)locale));
        labelMap.put("logo.title", I18nUtil.getMessage((String)(msgKey + ".logo.title"), (Locale)locale));
        labelMap.put("general-feed.description", I18nUtil.getMessage((String)(msgKey + ".general-feed.description"), (Locale)locale));
        labelMap.put("ui.type", "jspui");
        for (String selector : SyndicationFeed.getDescriptionSelectors()) {
            labelMap.put("metadata." + selector, I18nUtil.getMessage((String)("metadata." + selector), (Locale)locale));
        }
        return labelMap;
    }

    /*
     * Unable to fully structure code
     */
    public void doSimpleSearch(Context context, HttpServletRequest request, HttpServletResponse response) throws SearchProcessorException, IOException, ServletException {
        block28: {
            this.init();
            try {
                scope = DiscoverUtility.getSearchScope((Context)context, (HttpServletRequest)request);
            }
            catch (IllegalStateException e) {
                throw new SearchProcessorException(e.getMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                throw new SearchProcessorException(e.getMessage(), (Throwable)e);
            }
            discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)scope);
            sortFields = discoveryConfiguration.getSearchSortConfiguration().getSortFields();
            sortOptions = new ArrayList<String>();
            for (DiscoverySortFieldConfiguration sortFieldConfiguration : sortFields) {
                sortField = SearchUtils.getSearchService().toSortFieldIndex(sortFieldConfiguration.getMetadataField(), sortFieldConfiguration.getType());
                sortOptions.add(sortField);
            }
            request.setAttribute("sortOptions", sortOptions);
            queryArgs = DiscoverUtility.getDiscoverQuery((Context)context, (HttpServletRequest)request, (DSpaceObject)scope, (boolean)true);
            queryArgs.setSpellCheck(discoveryConfiguration.isSpellCheckEnabled());
            availableFacet = discoveryConfiguration.getSidebarFacets();
            request.setAttribute("facetsConfig", (Object)(availableFacet != null ? availableFacet : new ArrayList<E>()));
            etal = UIUtil.getIntParameter((HttpServletRequest)request, (String)"etal");
            if (etal == -1) {
                etal = ConfigurationManager.getIntProperty((String)"webui.itemlist.author-limit");
            }
            request.setAttribute("etal", (Object)etal);
            query = request.getParameter("query");
            request.setAttribute("query", (Object)query);
            request.setAttribute("queryArgs", (Object)queryArgs);
            availableFilters = discoveryConfiguration.getSearchFilters();
            request.setAttribute("availableFilters", (Object)availableFilters);
            appliedFilters = DiscoverUtility.getFilters((HttpServletRequest)request);
            request.setAttribute("appliedFilters", (Object)appliedFilters);
            appliedFilterQueries = new ArrayList<String>();
            for (String[] filter : appliedFilters) {
                appliedFilterQueries.add(filter[0] + "::" + filter[1] + "::" + filter[2]);
            }
            request.setAttribute("appliedFilterQueries", appliedFilterQueries);
            scopes = new ArrayList<Object>();
            if (scope == null) {
                try {
                    topCommunities = this.communityService.findAllTop(context);
                }
                catch (SQLException e) {
                    throw new SearchProcessorException(e.getMessage(), (Throwable)e);
                }
                for (Object com : topCommunities) {
                    scopes.add(com);
                }
            } else {
                try {
                    pDso = ContentServiceFactory.getInstance().getDSpaceObjectService(scope).getParentObject(context, scope);
                    while (pDso != null) {
                        scopes.add(0, pDso);
                        pDso = ContentServiceFactory.getInstance().getDSpaceObjectService(pDso).getParentObject(context, pDso);
                    }
                    scopes.add(scope);
                    if (!(scope instanceof Community)) ** GOTO lbl73
                    comms = ((Community)scope).getSubcommunities();
                    for (Object com : comms) {
                        scopes.add(com);
                    }
                    colls = ((Community)scope).getCollections();
                    for (Object col : colls) {
                        scopes.add(col);
                    }
                }
                catch (SQLException e) {
                    throw new SearchProcessorException(e.getMessage(), (Throwable)e);
                }
            }
lbl73:
            // 3 sources

            request.setAttribute("scope", (Object)scope);
            request.setAttribute("scopes", scopes);
            qResults = null;
            try {
                qResults = SearchUtils.getSearchService().search(context, scope, queryArgs);
                resultsListComm = new ArrayList<Community>();
                resultsListColl = new ArrayList<Collection>();
                resultsListItem = new ArrayList<Item>();
                for (DSpaceObject dso : qResults.getDspaceObjects()) {
                    if (dso instanceof Item) {
                        resultsListItem.add((Item)dso);
                        continue;
                    }
                    if (dso instanceof Collection) {
                        resultsListColl.add((Collection)dso);
                        continue;
                    }
                    if (!(dso instanceof Community)) continue;
                    resultsListComm.add((Community)dso);
                }
                DiscoverySearchRequestProcessor.log.info((Object)LogManager.getHeader((Context)context, (String)"search", (String)("scope=" + scope + ",query=\"" + query + "\",results=(" + resultsListComm.size() + "," + resultsListColl.size() + "," + resultsListItem.size() + ")")));
                pageTotal = 1L + (qResults.getTotalSearchResults() - 1L) / (long)qResults.getMaxResults();
                pageCurrent = 1 + qResults.getStart() / qResults.getMaxResults();
                pageLast = pageCurrent + 3L > pageTotal ? pageTotal : pageCurrent + 3L;
                pageFirst = pageCurrent - 3L > 1L ? pageCurrent - 3L : 1L;
                request.setAttribute("items", resultsListItem);
                request.setAttribute("communities", resultsListComm);
                request.setAttribute("collections", resultsListColl);
                request.setAttribute("pagetotal", (Object)new Long(pageTotal));
                request.setAttribute("pagecurrent", (Object)new Long(pageCurrent));
                request.setAttribute("pagelast", (Object)new Long(pageLast));
                request.setAttribute("pagefirst", (Object)new Long(pageFirst));
                request.setAttribute("spellcheck", (Object)qResults.getSpellCheckQuery());
                request.setAttribute("queryresults", (Object)qResults);
                try {
                    if (this.authorizeService.isAdmin(context)) {
                        request.setAttribute("admin_button", (Object)new Boolean(true));
                    }
                }
                catch (SQLException var31_32) {
                    // empty catch block
                }
                if (!"submit_export_metadata".equals(UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit"))) break block28;
                try {
                    if (this.authorizeService.isAdmin(context)) {
                        this.exportMetadata(context, response, resultsListItem);
                    } else {
                        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/error/authorize.jsp");
                    }
                }
                catch (SQLException e) {
                    throw new SearchProcessorException(e.getMessage(), (Throwable)e);
                }
            }
            catch (SearchServiceException e) {
                DiscoverySearchRequestProcessor.log.error((Object)LogManager.getHeader((Context)context, (String)"search", (String)("query=" + query + ",scope=" + scope + ",error=" + e.getMessage())), (Throwable)e);
                request.setAttribute("search.error", (Object)true);
                request.setAttribute("search.error.message", (Object)e.getMessage());
            }
        }
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/search/discovery.jsp");
    }

    protected void exportMetadata(Context context, HttpServletResponse response, List<Item> items) throws IOException, ServletException {
        log.info((Object)LogManager.getHeader((Context)context, (String)"metadataexport", (String)"exporting_search"));
        MetadataExport exporter = new MetadataExport(context, items.iterator(), false);
        DSpaceCSV csv = exporter.export();
        response.setContentType("text/csv; charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=search-results.csv");
        PrintWriter out = response.getWriter();
        out.write(csv.toString());
        out.flush();
        out.close();
        log.info((Object)LogManager.getHeader((Context)context, (String)"metadataexport", (String)"exported_file:search-results.csv"));
    }

    public void doAdvancedSearch(Context context, HttpServletRequest request, HttpServletResponse response) throws SearchProcessorException, IOException, ServletException {
        response.sendRedirect(request.getContextPath() + "/simple-search");
    }

    public void doItemMapSearch(Context context, HttpServletRequest request, HttpServletResponse response) throws SearchProcessorException, ServletException, IOException {
        this.init();
        String queryString = request.getParameter("query");
        Collection collection = (Collection)request.getAttribute("collection");
        int page = UIUtil.getIntParameter((HttpServletRequest)request, (String)"page") - 1;
        int offset = page > 0 ? page * 50 : 0;
        String idx = request.getParameter("index");
        if (StringUtils.isNotBlank((String)idx) && !idx.equalsIgnoreCase("any")) {
            queryString = idx + ":(" + queryString + ")";
        }
        DiscoverQuery query = new DiscoverQuery();
        query.setQuery(queryString);
        query.addFilterQueries(new String[]{"-location:l" + collection.getID()});
        query.setMaxResults(50);
        query.setStart(offset);
        DiscoverResult results = null;
        try {
            results = SearchUtils.getSearchService().search(context, query);
        }
        catch (SearchServiceException e) {
            throw new SearchProcessorException(e.getMessage(), (Throwable)e);
        }
        HashMap<String, Item> items = new HashMap<String, Item>();
        List resultDSOs = results.getDspaceObjects();
        for (DSpaceObject dso : resultDSOs) {
            if (dso == null || dso.getType() != 2) continue;
            Item item = (Item)dso;
            items.put(item.getID().toString(), item);
        }
        request.setAttribute("browsetext", (Object)queryString);
        request.setAttribute("items", items);
        request.setAttribute("more", (Object)(results.getTotalSearchResults() > (long)(offset + 50) ? 1 : 0));
        request.setAttribute("browsetype", (Object)"Add");
        request.setAttribute("page", (Object)(page > 0 ? page + 1 : 1));
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"itemmap-browse.jsp");
    }

    public String getI18NKeyPrefix() {
        return "jsp.search.filter.";
    }

    public List<String> getSearchIndices() {
        this.init();
        return this.searchIndices;
    }
}

