/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.submit.step;

import com.google.gson.Gson;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.sherpa.submit.SHERPASubmitService;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.webui.servlet.SubmissionController;
import org.dspace.app.webui.submit.JSPStep;
import org.dspace.app.webui.submit.JSPStepManager;
import org.dspace.app.webui.util.JSONUploadResponse;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.utils.DSpace;

public class JSPUploadStep
extends JSPStep {
    private static final String CHOOSE_FILE_JSP = "/submit/choose-file.jsp";
    private static final String UPLOAD_LIST_JSP = "/submit/upload-file-list.jsp";
    private static final String UPLOAD_FILE_JSP = "/submit/show-uploaded-file.jsp";
    private static final String FILE_DESCRIPTION_JSP = "/submit/change-file-description.jsp";
    private static final String FILE_FORMAT_JSP = "/submit/get-file-format.jsp";
    protected static final String UPLOAD_ERROR_JSP = "/submit/upload-error.jsp";
    protected static final String VIRUS_CHECKER_ERROR_JSP = "/submit/virus-checker-error.jsp";
    protected static final String VIRUS_ERROR_JSP = "/submit/virus-error.jsp";
    private static final String REVIEW_JSP = "/submit/review-upload.jsp";
    private static Logger log = Logger.getLogger(JSPUploadStep.class);
    private BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    private ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();

    public void doPreProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        if (subInfo != null) {
            Collection c = subInfo.getSubmissionItem().getCollection();
            try {
                DCInputsReader inputsReader = new DCInputsReader();
                request.setAttribute("submission.inputs", (Object)inputsReader.getInputs(c.getHandle()));
            }
            catch (DCInputsReaderException e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            throw new IllegalStateException("SubInfo must not be null");
        }
        this.showUploadPage(context, request, response, subInfo, false);
    }

    public void doPostProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, int status) throws ServletException, IOException, SQLException, AuthorizeException {
        Bitstream bitstream;
        UUID id;
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_next");
        boolean fileRequired = ConfigurationManager.getBooleanProperty((String)"webui.submit.upload.required", (boolean)true);
        if (UIUtil.getBoolParameter((HttpServletRequest)request, (String)"ajaxUpload")) {
            Gson gson = new Gson();
            response.setContentType("text/html");
            JSONUploadResponse jsonResponse = new JSONUploadResponse();
            String bitstreamName = null;
            UUID bitstreamID = null;
            long size = 0L;
            String url = null;
            if (subInfo.getBitstream() != null) {
                Bitstream bitstream2 = subInfo.getBitstream();
                bitstreamName = bitstream2.getName();
                bitstreamID = bitstream2.getID();
                size = bitstream2.getSize();
                url = request.getContextPath() + "/retrieve/" + bitstreamID + "/" + UIUtil.encodeBitstreamName((String)bitstreamName);
                jsonResponse.addUploadFileStatus(bitstreamName, bitstreamID, size, url, status);
                response.getWriter().print(gson.toJson((Object)jsonResponse));
                response.flushBuffer();
            }
            return;
        }
        if (buttonPressed.equalsIgnoreCase("submit_skip") || buttonPressed.equalsIgnoreCase("submit_upload") && !fileRequired) {
            Bundle bnd;
            List bundles = this.itemService.getBundles(subInfo.getSubmissionItem().getItem(), "ORIGINAL");
            boolean fileAlreadyUploaded = false;
            Iterator i$ = bundles.iterator();
            while (i$.hasNext() && !(fileAlreadyUploaded = (bnd = (Bundle)i$.next()).getBitstreams().size() > 0)) {
            }
            if (fileAlreadyUploaded) {
                this.showUploadFileList(context, request, response, subInfo, true, false);
            }
            return;
        }
        if (buttonPressed.equalsIgnoreCase("submit_retry")) {
            this.showUploadPage(context, request, response, subInfo, false);
        }
        if (status != 0) {
            DCInputsReader inputsReader;
            Collection c;
            if (status == 1) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
            } else if (status == 2 || status == 5) {
                if (buttonPressed.startsWith("submit_remove_")) {
                    this.showUploadPage(context, request, response, subInfo, false);
                } else {
                    if (subInfo != null) {
                        try {
                            c = subInfo.getSubmissionItem().getCollection();
                            inputsReader = new DCInputsReader();
                            request.setAttribute("submission.inputs", (Object)inputsReader.getInputs(c.getHandle()));
                        }
                        catch (DCInputsReaderException e) {
                            throw new ServletException((Throwable)e);
                        }
                    }
                    JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)UPLOAD_ERROR_JSP);
                }
            } else if (status == 14) {
                if (subInfo != null) {
                    try {
                        c = subInfo.getSubmissionItem().getCollection();
                        inputsReader = new DCInputsReader();
                        request.setAttribute("submission.inputs", (Object)inputsReader.getInputs(c.getHandle()));
                    }
                    catch (DCInputsReaderException e) {
                        throw new ServletException((Throwable)e);
                    }
                }
                JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)VIRUS_CHECKER_ERROR_JSP);
            } else if (status == 16) {
                if (subInfo != null) {
                    try {
                        c = subInfo.getSubmissionItem().getCollection();
                        inputsReader = new DCInputsReader();
                        request.setAttribute("submission.inputs", (Object)inputsReader.getInputs(c.getHandle()));
                    }
                    catch (DCInputsReaderException e) {
                        throw new ServletException((Throwable)e);
                    }
                }
                JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)VIRUS_ERROR_JSP);
            } else if (status == 10) {
                this.showGetFileFormat(context, request, response, subInfo);
            }
        }
        if (status == 0 && buttonPressed.equals("submit_next")) {
            return;
        }
        if (buttonPressed.equals("submit_more")) {
            this.showChooseFile(context, request, response, subInfo);
        } else if (buttonPressed.equals("submit_show_checksums")) {
            this.showUploadFileList(context, request, response, subInfo, false, true);
        } else if (buttonPressed.startsWith("submit_describe_")) {
            try {
                id = UUID.fromString(buttonPressed.substring(16));
                bitstream = (Bitstream)this.bitstreamService.find(context, id);
            }
            catch (NumberFormatException nfe) {
                bitstream = null;
            }
            if (bitstream == null) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
            }
            subInfo.setBitstream(bitstream);
            this.showFileDescription(context, request, response, subInfo);
        } else if (buttonPressed.startsWith("submit_format_")) {
            try {
                id = UUID.fromString(buttonPressed.substring(14));
                bitstream = (Bitstream)this.bitstreamService.find(context, id);
            }
            catch (NumberFormatException nfe) {
                bitstream = null;
            }
            if (bitstream == null) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
            }
            subInfo.setBitstream(bitstream);
            this.showGetFileFormat(context, request, response, subInfo);
        } else {
            String contentType = request.getContentType();
            boolean fileUpload = false;
            if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
                fileUpload = true;
            }
            this.showUploadPage(context, request, response, subInfo, fileUpload);
        }
    }

    protected void showUploadPage(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, boolean justUploaded) throws SQLException, ServletException, IOException {
        List bundles = this.itemService.getBundles(subInfo.getSubmissionItem().getItem(), "ORIGINAL");
        boolean fileAlreadyUploaded = false;
        if (!justUploaded) {
            Bundle bnd;
            Iterator i$ = bundles.iterator();
            while (i$.hasNext() && !(fileAlreadyUploaded = (bnd = (Bundle)i$.next()).getBitstreams().size() > 0)) {
            }
        }
        if (justUploaded || fileAlreadyUploaded) {
            this.showUploadFileList(context, request, response, subInfo, justUploaded, false);
        } else {
            this.showChooseFile(context, request, response, subInfo);
        }
    }

    protected void showChooseFile(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws SQLException, ServletException, IOException {
        if (ConfigurationManager.getBooleanProperty((String)"webui.submission.sherparomeo-policy-enabled", (boolean)true)) {
            SHERPASubmitService sherpaSubmitService = (SHERPASubmitService)new DSpace().getSingletonService(SHERPASubmitService.class);
            request.setAttribute("sherpa", (Object)sherpaSubmitService.hasISSNs(context, subInfo.getSubmissionItem().getItem()));
        }
        subInfo.setBitstream(null);
        boolean withEmbargo = SubmissionController.getCurrentStepConfig((HttpServletRequest)request, (SubmissionInfo)subInfo).getProcessingClassName().equals("org.dspace.submit.step.UploadWithEmbargoStep");
        request.setAttribute("with_embargo", (Object)withEmbargo);
        JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)CHOOSE_FILE_JSP);
    }

    protected void showUploadFileList(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, boolean justUploaded, boolean showChecksums) throws SQLException, ServletException, IOException {
        request.setAttribute("just.uploaded", (Object)justUploaded);
        request.setAttribute("show.checksums", (Object)showChecksums);
        boolean withEmbargo = SubmissionController.getCurrentStepConfig((HttpServletRequest)request, (SubmissionInfo)subInfo).getProcessingClassName().equals("org.dspace.submit.step.UploadWithEmbargoStep");
        request.setAttribute("with_embargo", (Object)withEmbargo);
        if (subInfo.isInWorkflow() || subInfo.getSubmissionItem().hasMultipleFiles()) {
            JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)UPLOAD_LIST_JSP);
        } else {
            JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)UPLOAD_FILE_JSP);
        }
    }

    protected void showGetFileFormat(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws SQLException, ServletException, IOException {
        if (subInfo == null || subInfo.getBitstream() == null) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
            JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
        }
        List formats = this.bitstreamFormatService.findNonInternal(context);
        request.setAttribute("bitstream.formats", (Object)formats);
        BitstreamFormat guess = this.bitstreamFormatService.guessFormat(context, subInfo.getBitstream());
        request.setAttribute("guessed.format", (Object)guess);
        JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)FILE_FORMAT_JSP);
    }

    protected void showFileDescription(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws SQLException, ServletException, IOException {
        JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)FILE_DESCRIPTION_JSP);
    }

    public String getReviewJSP(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) {
        return REVIEW_JSP;
    }
}

