/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.Util;
import org.dspace.app.webui.discovery.DiscoverySearchRequestProcessor;
import org.dspace.app.webui.search.SearchProcessorException;
import org.dspace.app.webui.search.SearchRequestProcessor;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.PluginConfigurationError;
import org.dspace.core.factory.CoreServiceFactory;

public class ItemMapServlet
extends DSpaceServlet {
    private transient SearchRequestProcessor internalLogic;
    private final transient CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private final transient ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private static final Logger log = Logger.getLogger(ItemMapServlet.class);

    public ItemMapServlet() {
        try {
            this.internalLogic = (SearchRequestProcessor)CoreServiceFactory.getInstance().getPluginService().getSinglePlugin(SearchRequestProcessor.class);
        }
        catch (PluginConfigurationError e) {
            log.warn((Object)"ItemMapServlet not properly configured -- please configure the SearchRequestProcessor plugin", (Throwable)e);
        }
        if (this.internalLogic == null) {
            this.internalLogic = new DiscoverySearchRequestProcessor();
        }
    }

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws SQLException, ServletException, IOException, AuthorizeException {
        this.doDSPost(context, request, response);
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws SQLException, ServletException, IOException, AuthorizeException {
        String cancel;
        String jspPage = null;
        UUID myID = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"cid");
        Collection myCollection = (Collection)this.collectionService.find(context, myID);
        this.authorizeService.authorizeAction(context, (DSpaceObject)myCollection, 11);
        String action = request.getParameter("action");
        if (action == null) {
            action = "";
        }
        if ((cancel = request.getParameter("cancel")) == null) {
            cancel = "";
        }
        if (action.equals("") || !cancel.equals("")) {
            int count_native = 0;
            int count_import = 0;
            HashMap<UUID, Item> myItems = new HashMap<UUID, Item>();
            HashMap<UUID, Collection> myCollections = new HashMap<UUID, Collection>();
            HashMap<UUID, Integer> myCounts = new HashMap<UUID, Integer>();
            Iterator i = this.itemService.findAllByCollection(context, myCollection);
            while (i.hasNext()) {
                Item myItem = (Item)i.next();
                UUID myKey = myItem.getID();
                if (this.itemService.isOwningCollection(myItem, myCollection)) {
                    ++count_native;
                } else {
                    ++count_import;
                }
                Collection owningCollection = myItem.getOwningCollection();
                UUID cKey = owningCollection.getID();
                if (myCollections.containsKey(cKey)) {
                    Integer x = (Integer)myCounts.get(cKey);
                    int myCount = x + 1;
                    myCounts.put(cKey, myCount);
                } else {
                    myCollections.put(cKey, owningCollection);
                    myCounts.put(cKey, 1);
                }
                myItems.put(myKey, myItem);
            }
            myCollections.remove(myCollection.getID());
            request.setAttribute("collection", (Object)myCollection);
            request.setAttribute("count_native", (Object)count_native);
            request.setAttribute("count_import", (Object)count_import);
            request.setAttribute("items", myItems);
            request.setAttribute("collections", myCollections);
            request.setAttribute("collection_counts", myCounts);
            request.setAttribute("all_collections", (Object)this.collectionService.findAll(context));
            request.setAttribute("searchIndices", (Object)this.internalLogic.getSearchIndices());
            request.setAttribute("prefixKey", (Object)this.internalLogic.getI18NKeyPrefix());
            jspPage = "itemmap-main.jsp";
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)jspPage);
        } else if (action.equals("Remove")) {
            List itemIDs = Util.getUUIDParameters((HttpServletRequest)request, (String)"item_ids");
            String message = "remove";
            LinkedList<UUID> removedItems = new LinkedList<UUID>();
            if (itemIDs == null) {
                message = "none-removed";
            } else {
                for (UUID i : itemIDs) {
                    removedItems.add(i);
                    Item myItem = (Item)this.itemService.find(context, i);
                    if (this.itemService.isOwningCollection(myItem, myCollection)) continue;
                    this.collectionService.removeItem(context, myCollection, myItem);
                }
            }
            request.setAttribute("message", (Object)message);
            request.setAttribute("collection", (Object)myCollection);
            request.setAttribute("processedItems", removedItems);
            jspPage = "itemmap-info.jsp";
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)jspPage);
        } else if (action.equals("Add")) {
            List itemIDs = Util.getUUIDParameters((HttpServletRequest)request, (String)"item_ids");
            String message = "added";
            LinkedList<UUID> addedItems = new LinkedList<UUID>();
            if (itemIDs == null) {
                message = "none-selected";
            } else {
                for (UUID i : itemIDs) {
                    Item myItem = (Item)this.itemService.find(context, i);
                    if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)myItem, 0) || this.itemService.isOwningCollection(myItem, myCollection)) continue;
                    this.collectionService.addItem(context, myCollection, myItem);
                    addedItems.add(i);
                }
            }
            request.setAttribute("message", (Object)message);
            request.setAttribute("collection", (Object)myCollection);
            request.setAttribute("processedItems", addedItems);
            jspPage = "itemmap-info.jsp";
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)jspPage);
        } else if (action.equals("search")) {
            request.setAttribute("collection", (Object)myCollection);
            try {
                this.internalLogic.doItemMapSearch(context, request, response);
            }
            catch (SearchProcessorException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        } else if (action.equals("browse")) {
            UUID t = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"t");
            Collection targetCollection = (Collection)this.collectionService.find(context, t);
            HashMap<UUID, Item> items = new HashMap<UUID, Item>();
            Iterator i = this.itemService.findAllByCollection(context, myCollection);
            while (i.hasNext()) {
                Item myItem = (Item)i.next();
                if (!this.itemService.isOwningCollection(myItem, targetCollection)) continue;
                items.put(myItem.getID(), myItem);
            }
            request.setAttribute("collection", (Object)myCollection);
            request.setAttribute("browsetext", (Object)targetCollection.getName());
            request.setAttribute("items", items);
            request.setAttribute("browsetype", (Object)"Remove");
            jspPage = "itemmap-browse.jsp";
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)jspPage);
        }
        context.complete();
    }
}

