/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.Authenticate;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authenticate.factory.AuthenticateServiceFactory;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.AccountService;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;

public class EPersonAdminServlet
extends DSpaceServlet {
    private final transient EPersonService personService = EPersonServiceFactory.getInstance().getEPersonService();
    private final transient GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    private final transient AuthenticationService authenticationService = AuthenticateServiceFactory.getInstance().getAuthenticationService();
    private final transient AccountService accountService = EPersonServiceFactory.getInstance().getAccountService();
    private static final Logger log = Logger.getLogger(EPersonAdminServlet.class);

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.showMain(context, request, response);
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
        if (button.equals("submit_add")) {
            EPerson e = this.personService.create(context);
            e.setEmail("newuser" + e.getID());
            this.personService.update(context, (DSpaceObject)e);
            request.setAttribute("eperson", (Object)e);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/eperson-edit.jsp");
            context.complete();
        } else if (button.equals("submit_edit")) {
            EPerson e = (EPerson)this.personService.find(context, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"eperson_id"));
            if (e == null) {
                request.setAttribute("no_eperson_selected", (Object)Boolean.TRUE);
                this.showMain(context, request, response);
            } else {
                List groupMemberships = this.groupService.allMemberGroups(context, e);
                request.setAttribute("eperson", (Object)e);
                request.setAttribute("group.memberships", (Object)groupMemberships);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/eperson-edit.jsp");
                context.complete();
            }
        } else if (button.equals("submit_save") || button.equals("submit_resetpassword")) {
            EPerson e = (EPerson)this.personService.find(context, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"eperson_id"));
            String oldEmail = e.getEmail();
            String newEmail = request.getParameter("email").trim();
            String netid = request.getParameter("netid");
            if (!newEmail.equals(oldEmail)) {
                if (this.personService.findByEmail(context, newEmail) == null) {
                    e.setEmail(newEmail);
                    e.setFirstName(context, request.getParameter("firstname").equals("") ? null : request.getParameter("firstname"));
                    e.setLastName(context, request.getParameter("lastname").equals("") ? null : request.getParameter("lastname"));
                    if (netid != null) {
                        e.setNetid(netid.equals("") ? null : netid.toLowerCase());
                    } else {
                        e.setNetid(null);
                    }
                    this.personService.setMetadata(context, e, "phone", request.getParameter("phone").equals("") ? null : request.getParameter("phone"));
                    this.personService.setMetadata(context, e, "language", request.getParameter("language").equals("") ? null : request.getParameter("language"));
                    e.setCanLogIn(request.getParameter("can_log_in") != null && request.getParameter("can_log_in").equals("true"));
                    e.setRequireCertificate(request.getParameter("require_certificate") != null && request.getParameter("require_certificate").equals("true"));
                    this.personService.update(context, (DSpaceObject)e);
                    if (button.equals("submit_resetpassword")) {
                        try {
                            this.resetPassword(context, request, response, e);
                        }
                        catch (MessagingException e1) {
                            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/eperson-resetpassword-error.jsp");
                            return;
                        }
                    }
                    this.showMain(context, request, response);
                    context.complete();
                } else {
                    request.setAttribute("eperson", (Object)e);
                    request.setAttribute("email_exists", (Object)Boolean.TRUE);
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/eperson-edit.jsp");
                    context.complete();
                }
            } else {
                if (netid != null) {
                    e.setNetid(netid.equals("") ? null : netid.toLowerCase());
                } else {
                    e.setNetid(null);
                }
                e.setFirstName(context, request.getParameter("firstname").equals("") ? null : request.getParameter("firstname"));
                e.setLastName(context, request.getParameter("lastname").equals("") ? null : request.getParameter("lastname"));
                this.personService.setMetadata(context, e, "phone", request.getParameter("phone").equals("") ? null : request.getParameter("phone"));
                this.personService.setMetadata(context, e, "language", request.getParameter("language").equals("") ? null : request.getParameter("language"));
                e.setCanLogIn(request.getParameter("can_log_in") != null && request.getParameter("can_log_in").equals("true"));
                e.setRequireCertificate(request.getParameter("require_certificate") != null && request.getParameter("require_certificate").equals("true"));
                this.personService.update(context, (DSpaceObject)e);
                if (button.equals("submit_resetpassword")) {
                    try {
                        this.resetPassword(context, request, response, e);
                    }
                    catch (MessagingException e1) {
                        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/eperson-resetpassword-error.jsp");
                        return;
                    }
                }
                this.showMain(context, request, response);
                context.complete();
            }
        } else if (button.equals("submit_delete")) {
            EPerson e = (EPerson)this.personService.find(context, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"eperson_id"));
            if (e == null) {
                request.setAttribute("no_eperson_selected", (Object)Boolean.TRUE);
                this.showMain(context, request, response);
            } else {
                request.setAttribute("eperson", (Object)e);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/eperson-confirm-delete.jsp");
            }
        } else if (button.equals("submit_confirm_delete")) {
            EPerson e = (EPerson)this.personService.find(context, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"eperson_id"));
            try {
                this.personService.delete(context, (DSpaceObject)e);
            }
            catch (SQLException ex) {
                request.setAttribute("eperson", (Object)e);
                request.setAttribute("tableList", (Object)ex.getMessage());
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/eperson-deletion-error.jsp");
            }
            this.showMain(context, request, response);
            context.complete();
        } else if (button.equals("submit_login_as")) {
            if (!ConfigurationManager.getBooleanProperty((String)"webui.user.assumelogin", (boolean)false)) {
                throw new AuthorizeException("Turn on webui.user.assumelogin to activate Login As feature");
            }
            EPerson e = (EPerson)this.personService.find(context, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"eperson_id"));
            if (e == null) {
                request.setAttribute("no_eperson_selected", (Object)Boolean.TRUE);
                this.showMain(context, request, response);
            } else {
                if (!this.authorizeService.isAdmin(context)) {
                    throw new AuthorizeException("Only site administrators may assume login as another user.");
                }
                log.info((Object)LogManager.getHeader((Context)context, (String)"login-as", (String)("current_eperson=" + context.getCurrentUser().getFullName() + ", id=" + context.getCurrentUser().getID() + ", as_eperson=" + e.getFullName() + ", id=" + e.getID())));
                HttpSession session = request.getSession(false);
                UUID authenticatedID = (UUID)session.getAttribute("dspace.current.user.id");
                if (context.getCurrentUser().getID() != authenticatedID) {
                    throw new AuthorizeException("Only authenticated users who are administrators may assume the login as another user.");
                }
                Group administrators = this.groupService.findByName(context, "Administrator");
                if (this.groupService.isDirectMember(administrators, e)) {
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/eperson-loginas-error.jsp");
                    return;
                }
                session.setAttribute("dspace.previous.user.id", (Object)authenticatedID);
                Authenticate.loggedIn((Context)context, (HttpServletRequest)request, (EPerson)e);
                Locale epersonLocale = I18nUtil.getEPersonLocale((EPerson)context.getCurrentUser());
                context.setCurrentLocale(epersonLocale);
                Config.set((HttpSession)request.getSession(), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)epersonLocale);
                List groupIDs = this.authenticationService.getSpecialGroups(context, request);
                for (Group g : groupIDs) {
                    context.setSpecialGroup(g.getID());
                    log.debug((Object)("Adding Special Group id=" + String.valueOf(g.getID())));
                }
                response.sendRedirect(request.getContextPath() + "/mydspace");
            }
        } else {
            this.showMain(context, request, response);
        }
    }

    private void resetPassword(Context context, HttpServletRequest request, HttpServletResponse response, EPerson e) throws SQLException, IOException, AuthorizeException, ServletException, MessagingException {
        this.accountService.sendForgotPasswordInfo(context, e.getEmail());
        request.setAttribute("reset_password", (Object)Boolean.TRUE);
    }

    private void showMain(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/eperson-main.jsp");
    }
}

