/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.core.Context;

public class BitstreamFormatRegistry
extends DSpaceServlet {
    public static final int START_EDIT = 1;
    public static final int START_DELETE = 2;
    public static final int CONFIRM_EDIT = 3;
    public static final int CONFIRM_DELETE = 4;
    public static final int CREATE = 4;
    private final transient BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.showFormats(context, request, response);
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
        if (button.equals("submit_update")) {
            BitstreamFormat bf = (BitstreamFormat)this.bitstreamFormatService.find(context, UIUtil.getIntParameter((HttpServletRequest)request, (String)"format_id"));
            bf.setMIMEType(request.getParameter("mimetype"));
            bf.setShortDescription(context, request.getParameter("short_description"));
            bf.setDescription(request.getParameter("description"));
            bf.setSupportLevel(UIUtil.getIntParameter((HttpServletRequest)request, (String)"support_level"));
            bf.setInternal(request.getParameter("internal") != null && request.getParameter("internal").equals("true"));
            LinkedList<String> extensions = new LinkedList<String>();
            String extParam = request.getParameter("extensions");
            while (extParam.length() > 0) {
                int c = extParam.indexOf(44);
                if (c > 0) {
                    extensions.add(extParam.substring(0, c).trim());
                    extParam = extParam.substring(c + 1).trim();
                    continue;
                }
                if (extParam.trim().length() <= 0) continue;
                extensions.add(extParam.trim());
                extParam = "";
            }
            bf.setExtensions(extensions);
            this.bitstreamFormatService.update(context, (Object)bf);
            this.showFormats(context, request, response);
            context.complete();
        } else if (button.equals("submit_add")) {
            BitstreamFormat bf = (BitstreamFormat)this.bitstreamFormatService.create(context);
            bf.setInternal(true);
            this.bitstreamFormatService.update(context, (Object)bf);
            this.showFormats(context, request, response);
            context.complete();
        } else if (button.equals("submit_delete")) {
            BitstreamFormat bf = (BitstreamFormat)this.bitstreamFormatService.find(context, UIUtil.getIntParameter((HttpServletRequest)request, (String)"format_id"));
            request.setAttribute("format", (Object)bf);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/confirm-delete-format.jsp");
        } else if (button.equals("submit_confirm_delete")) {
            BitstreamFormat bf = (BitstreamFormat)this.bitstreamFormatService.find(context, UIUtil.getIntParameter((HttpServletRequest)request, (String)"format_id"));
            this.bitstreamFormatService.delete(context, (Object)bf);
            this.showFormats(context, request, response);
            context.complete();
        } else {
            this.showFormats(context, request, response);
        }
    }

    private void showFormats(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        List formats = this.bitstreamFormatService.findAll(context);
        request.setAttribute("formats", (Object)formats);
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/list-formats.jsp");
    }
}

