/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.SubscribeService;

public class SubscribeServlet
extends DSpaceServlet {
    private final transient SubscribeService subscribeService = EPersonServiceFactory.getInstance().getSubscribeService();
    private final transient CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.showSubscriptions(context, request, response, false);
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String submit = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
        EPerson e = context.getCurrentUser();
        if (submit.equals("submit_clear")) {
            this.subscribeService.unsubscribe(context, e, null);
            this.showSubscriptions(context, request, response, true);
            context.complete();
        } else if (submit.equals("submit_subscribe")) {
            UUID collID = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"collection");
            Collection c = (Collection)this.collectionService.find(context, collID);
            if (c != null) {
                this.subscribeService.subscribe(context, e, c);
            }
            this.showSubscriptions(context, request, response, true);
            context.complete();
        } else if (submit.equals("submit_unsubscribe")) {
            UUID collID = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"collection");
            Collection c = (Collection)this.collectionService.find(context, collID);
            if (c != null) {
                this.subscribeService.unsubscribe(context, e, c);
            }
            this.showSubscriptions(context, request, response, true);
            context.complete();
        } else {
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/mydspace"));
        }
    }

    private void showSubscriptions(Context context, HttpServletRequest request, HttpServletResponse response, boolean updated) throws ServletException, IOException, SQLException {
        List avail = this.subscribeService.getAvailableSubscriptions(context);
        List subs = this.subscribeService.getSubscriptions(context, context.getCurrentUser());
        request.setAttribute("availableSubscriptions", (Object)avail);
        request.setAttribute("subscriptions", (Object)subs);
        request.setAttribute("updated", (Object)updated);
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/subscriptions.jsp");
    }
}

