/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.Utils;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;

/*
 * Exception performing whole class analysis ignored.
 */
public class HTMLServlet
extends DSpaceServlet {
    private static final Logger log = Logger.getLogger(HTMLServlet.class);
    private final int maxDepthGuess = ConfigurationManager.getProperty((String)"webui.html.max-depth-guess") != null ? ConfigurationManager.getIntProperty((String)"webui.html.max-depth-guess") : 3;
    private final transient ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private final transient HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    private final transient BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();

    private static Bitstream getItemBitstreamByName(Item item, String bsName) throws SQLException {
        List bundles = item.getBundles();
        for (Bundle bundle : bundles) {
            List bitstreams = bundle.getBitstreams();
            for (Bitstream bb : bitstreams) {
                if (!bsName.equals(bb.getName())) continue;
                return bb;
            }
        }
        return null;
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSGet(context, request, response);
    }

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        Item item = null;
        Bitstream bitstream = null;
        String idString = request.getPathInfo();
        String filenameNoPath = null;
        String fullpath = null;
        String handle = null;
        if (idString != null) {
            int slashIndex;
            if (idString.startsWith("/")) {
                idString = idString.substring(1);
            }
            if ((slashIndex = idString.indexOf(47)) != -1 && (slashIndex = idString.indexOf(47, slashIndex + 1)) != -1) {
                String[] pathComponents;
                handle = idString.substring(0, slashIndex);
                fullpath = URLDecoder.decode(idString.substring(slashIndex + 1), "UTF-8");
                if ((slashIndex = fullpath.indexOf(47)) != -1 && (pathComponents = fullpath.split("/")).length <= this.maxDepthGuess + 1) {
                    filenameNoPath = pathComponents[pathComponents.length - 1];
                }
            }
        }
        if (handle != null && fullpath != null) {
            try {
                if (handle.startsWith("db-id")) {
                    String dbIDString = handle.substring(handle.indexOf(47) + 1);
                    item = (Item)this.itemService.findByIdOrLegacyId(context, dbIDString);
                } else {
                    item = (Item)this.handleService.resolveToObject(context, handle);
                }
            }
            catch (NumberFormatException dbIDString) {
                // empty catch block
            }
        }
        if (item != null && (bitstream = HTMLServlet.getItemBitstreamByName(item, fullpath)) == null && filenameNoPath != null) {
            bitstream = HTMLServlet.getItemBitstreamByName(item, filenameNoPath);
        }
        if (bitstream != null) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"view_html", (String)("handle=" + handle + ",bitstream_id=" + bitstream.getID())));
            DSpaceServicesFactory.getInstance().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, request, context, (DSpaceObject)bitstream));
            response.setContentType(bitstream.getFormat(context).getMIMEType());
            response.setHeader("Content-Length", String.valueOf(bitstream.getSize()));
            InputStream is = this.bitstreamService.retrieve(context, bitstream);
            Utils.bufferedCopy((InputStream)is, (OutputStream)response.getOutputStream());
            is.close();
            response.getOutputStream().flush();
        } else {
            log.info((Object)LogManager.getHeader((Context)context, (String)"view_html", (String)("invalid_bitstream_id=" + idString)));
            JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)idString, (int)0);
        }
    }
}

