/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;

/*
 * Exception performing whole class analysis ignored.
 */
public class ControlledVocabularySearchServlet
extends DSpaceServlet {
    private static final Logger log = Logger.getLogger(ControlledVocabularySearchServlet.class);
    private static final String SEARCH_JSP = "/controlledvocabulary/search.jsp";
    private static final String RESULTS_JSP = "/controlledvocabulary/results.jsp";
    private final transient HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    private final transient CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String action;
        String string = action = request.getParameter("action") == null ? "" : request.getParameter("action");
        if (action.equals("search")) {
            List keywords = this.extractKeywords(request);
            String query = ControlledVocabularySearchServlet.join((List)keywords, (String)" or ");
            this.doSearch(context, request, query);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/controlledvocabulary/results.jsp");
        } else if (action.equals("filter")) {
            String filter = request.getParameter("filter");
            request.getSession().setAttribute("conceptsearch.filter", (Object)filter);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/controlledvocabulary/search.jsp");
        } else {
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/controlledvocabulary/search.jsp");
        }
    }

    private List<String> extractKeywords(HttpServletRequest request) {
        ArrayList<String> keywords = new ArrayList<String>();
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String element = (String)enumeration.nextElement();
            if (!element.startsWith("cb_")) continue;
            keywords.add("\"" + request.getParameter(element) + "\"");
        }
        return keywords;
    }

    private void doSearch(Context context, HttpServletRequest request, String query) throws IOException, SQLException {
        int start = UIUtil.getIntParameter((HttpServletRequest)request, (String)"start");
        if (start < 0) {
            start = 0;
        }
        DiscoverQuery qArgs = new DiscoverQuery();
        if (query == null) {
            query = "";
        }
        String logInfo = "";
        Community community = UIUtil.getCommunityLocation((HttpServletRequest)request);
        Collection collection = UIUtil.getCollectionLocation((HttpServletRequest)request);
        qArgs.setQuery(query);
        qArgs.setStart(start);
        DiscoverResult qResults = null;
        try {
            if (collection != null) {
                logInfo = "collection_id=" + collection.getID() + ",";
                request.setAttribute("community", (Object)community);
                request.setAttribute("collection", (Object)collection);
                qResults = SearchUtils.getSearchService().search(context, (DSpaceObject)collection, qArgs);
            } else if (community != null) {
                logInfo = "community_id=" + community.getID() + ",";
                request.setAttribute("community", (Object)community);
                qResults = SearchUtils.getSearchService().search(context, (DSpaceObject)community, qArgs);
            } else {
                qResults = SearchUtils.getSearchService().search(context, qArgs);
            }
        }
        catch (SearchServiceException e) {
            throw new IOException(e);
        }
        ArrayList<Community> resultsListComm = new ArrayList<Community>();
        ArrayList<Collection> resultsListColl = new ArrayList<Collection>();
        ArrayList<Item> resultsListItem = new ArrayList<Item>();
        for (DSpaceObject dso : qResults.getDspaceObjects()) {
            if (dso instanceof Item) {
                resultsListItem.add((Item)dso);
                continue;
            }
            if (dso instanceof Collection) {
                resultsListColl.add((Collection)dso);
                continue;
            }
            if (!(dso instanceof Community)) continue;
            resultsListComm.add((Community)dso);
        }
        log.info((Object)LogManager.getHeader((Context)context, (String)"search", (String)(logInfo + "query=\"" + query + "\",results=(" + resultsListComm.size() + "," + resultsListColl.size() + "," + resultsListItem.size() + ")")));
        long pageTotal = 1L + (qResults.getTotalSearchResults() - 1L) / (long)qResults.getMaxResults();
        long pageCurrent = 1 + qResults.getStart() / qResults.getMaxResults();
        long pageLast = pageCurrent + 9L > pageTotal ? pageTotal : pageCurrent + 9L;
        long pageFirst = pageCurrent - 9L > 1L ? pageCurrent - 9L : 1L;
        request.setAttribute("items", resultsListItem);
        request.setAttribute("communities", resultsListComm);
        request.setAttribute("collections", resultsListColl);
        request.setAttribute("pagetotal", (Object)pageTotal);
        request.setAttribute("pagecurrent", (Object)pageCurrent);
        request.setAttribute("pagelast", (Object)pageLast);
        request.setAttribute("pagefirst", (Object)pageFirst);
        request.setAttribute("queryresults", (Object)qResults);
        request.setAttribute("query", (Object)query);
    }

    public static String join(List<String> list, String separator) {
        StringBuilder result = new StringBuilder();
        for (String entry : list) {
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(entry);
        }
        return result.toString();
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSGet(context, request, response);
    }
}

