/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.Utils;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;

public class BitstreamServlet
extends DSpaceServlet {
    private static final Logger log = Logger.getLogger(BitstreamServlet.class);
    private int threshold;
    private final transient HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    private final transient BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();

    public void init(ServletConfig arg0) throws ServletException {
        super.init(arg0);
        this.threshold = ConfigurationManager.getIntProperty((String)"webui.content_disposition_threshold");
    }

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        int sequenceID;
        int slashIndex;
        Item item = null;
        Bitstream bitstream = null;
        String idString = request.getPathInfo();
        String handle = "";
        String sequenceText = "";
        String filename = null;
        if (idString == null) {
            idString = "";
        }
        if (idString.startsWith("/")) {
            idString = idString.substring(1);
        }
        if ((slashIndex = idString.indexOf(47)) != -1 && (slashIndex = idString.indexOf(47, slashIndex + 1)) != -1) {
            handle = idString.substring(0, slashIndex);
            int slash2 = idString.indexOf(47, slashIndex + 1);
            if (slash2 != -1) {
                sequenceText = idString.substring(slashIndex + 1, slash2);
                filename = idString.substring(slash2 + 1);
            }
        }
        try {
            sequenceID = Integer.parseInt(sequenceText);
        }
        catch (NumberFormatException nfe) {
            sequenceID = -1;
        }
        DSpaceObject dso = this.handleService.resolveToObject(context, handle);
        if (dso != null && dso.getType() == 2 && sequenceID >= 0) {
            item = (Item)dso;
            if (item.isWithdrawn()) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"view_bitstream", (String)("handle=" + handle + ",withdrawn=true")));
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tombstone.jsp");
                return;
            }
            boolean found = false;
            List bundles = item.getBundles();
            for (int i = 0; i < bundles.size() && !found; ++i) {
                List bitstreams = ((Bundle)bundles.get(i)).getBitstreams();
                for (int k = 0; k < bitstreams.size() && !found; ++k) {
                    if (sequenceID != ((Bitstream)bitstreams.get(k)).getSequenceID()) continue;
                    bitstream = (Bitstream)bitstreams.get(k);
                    found = true;
                }
            }
        }
        if (bitstream == null || filename == null || !filename.equals(bitstream.getName())) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"invalid_id", (String)("path=" + idString)));
            JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)idString, (int)0);
            return;
        }
        log.info((Object)LogManager.getHeader((Context)context, (String)"view_bitstream", (String)("bitstream_id=" + bitstream.getID())));
        DSpaceServicesFactory.getInstance().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, request, context, bitstream));
        if (context.getCurrentUser() == null) {
            response.setDateHeader("Last-Modified", item.getLastModified().getTime());
            long modSince = request.getDateHeader("If-Modified-Since");
            if (modSince != -1L && item.getLastModified().getTime() < modSince) {
                response.setStatus(304);
                return;
            }
        }
        InputStream is = this.bitstreamService.retrieve(context, bitstream);
        response.setContentType(bitstream.getFormat(context).getMIMEType());
        response.setHeader("Content-Length", String.valueOf(bitstream.getSize()));
        if (this.threshold != -1 && bitstream.getSize() >= (long)this.threshold) {
            UIUtil.setBitstreamDisposition((String)bitstream.getName(), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        context.complete();
        Utils.bufferedCopy((InputStream)is, (OutputStream)response.getOutputStream());
        is.close();
        response.getOutputStream().flush();
    }
}

