/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.jsptag;

import java.io.IOException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.Util;
import org.dspace.app.util.factory.UtilServiceFactory;
import org.dspace.app.util.service.MetadataExposureService;
import org.dspace.app.webui.util.StyleSelection;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.browse.BrowseException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.authority.factory.ContentAuthorityServiceFactory;
import org.dspace.content.authority.service.MetadataAuthorityService;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.Utils;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.workflow.WorkflowItemService;
import org.dspace.workflow.factory.WorkflowServiceFactory;

public class ItemTag
extends TagSupport {
    private static final String HANDLE_DEFAULT_BASEURL = "http://hdl.handle.net/";
    private static final String DOI_DEFAULT_BASEURL = "http://dx.doi.org/";
    private Item item;
    private List<Collection> collections;
    private String style;
    private boolean showThumbs;
    private static final String defaultFields = "dc.title, dc.title.alternative, dc.contributor.*, dc.subject, dc.date.issued(date), dc.publisher, dc.identifier.citation, dc.relation.ispartofseries, dc.description.abstract, dc.description, dc.identifier.govdoc, dc.identifier.uri(link), dc.identifier.isbn, dc.identifier.issn, dc.identifier.ismn, dc.identifier";
    private static final Logger log;
    private final transient StyleSelection styleSelection = (StyleSelection)CoreServiceFactory.getInstance().getPluginService().getSinglePlugin(StyleSelection.class);
    private static final Map<String, String> linkedMetadata;
    private static final Map<String, String> urn2baseurl;
    private final Pattern fieldStylePatter = Pattern.compile(".*\\((.*)\\)");
    private static final long serialVersionUID = -3841266490729417240L;
    private final transient MetadataExposureService metadataExposureService = UtilServiceFactory.getInstance().getMetadataExposureService();
    private final transient ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private final transient MetadataAuthorityService metadataAuthorityService = ContentAuthorityServiceFactory.getInstance().getMetadataAuthorityService();
    private final transient BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    private final transient AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    private final transient WorkflowItemService workflowItemService = WorkflowServiceFactory.getInstance().getWorkflowItemService();
    private final transient WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    private final transient ResourcePolicyService resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();
    private final transient GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();

    public ItemTag() {
        this.getThumbSettings();
    }

    public int doStartTag() throws JspException {
        try {
            if (this.style == null || this.style.equals("")) {
                this.style = this.styleSelection.getStyleForItem(this.item);
            }
            if (this.style.equals("full")) {
                this.renderFull();
            } else {
                this.render();
            }
        }
        catch (SQLException sqle) {
            throw new JspException((Throwable)sqle);
        }
        catch (IOException ie) {
            throw new JspException((Throwable)ie);
        }
        catch (DCInputsReaderException ex) {
            throw new JspException((Throwable)ex);
        }
        return 0;
    }

    public Item getItem() {
        return this.item;
    }

    public void setItem(Item itemIn) {
        this.item = itemIn;
    }

    public List<Collection> getCollections() {
        return this.collections;
    }

    public void setCollections(List<Collection> collectionsIn) {
        this.collections = collectionsIn;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String styleIn) {
        this.style = styleIn;
    }

    public void release() {
        this.style = "default";
        this.item = null;
        this.collections = null;
    }

    private void render() throws IOException, SQLException, DCInputsReaderException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Context context = UIUtil.obtainContext((HttpServletRequest)request);
        Locale sessionLocale = UIUtil.getSessionLocale((HttpServletRequest)request);
        Object[] metadataFields = this.styleSelection.getConfigurationForStyle(this.style);
        if (ArrayUtils.isEmpty((Object[])metadataFields)) {
            metadataFields = defaultFields.split(",");
        }
        out.println("<table class=\"table itemDisplayTable\">");
        for (Object field : metadataFields) {
            List values;
            String browseIndex;
            field = ((String)field).trim();
            boolean isDate = false;
            boolean isLink = false;
            boolean isResolver = false;
            boolean isNoBreakLine = false;
            boolean isDisplay = false;
            String style = null;
            Matcher fieldStyleMatcher = this.fieldStylePatter.matcher((CharSequence)field);
            if (fieldStyleMatcher.matches()) {
                style = fieldStyleMatcher.group(1);
            }
            try {
                browseIndex = this.getBrowseField((String)field);
            }
            catch (BrowseException e) {
                log.error((Object)e);
                browseIndex = null;
            }
            if (style != null) {
                isDate = style.contains("date");
                isLink = style.contains("link");
                isNoBreakLine = style.contains("nobreakline");
                isDisplay = style.equals("inputform");
                isResolver = style.contains("resolver") || urn2baseurl.keySet().contains(style);
                field = ((String)field).replaceAll("\\(" + style + "\\)", "");
            }
            String[] eq = ((String)field).split("\\.");
            String schema = eq[0];
            String element = eq[1];
            String qualifier = null;
            if (eq.length > 2 && eq[2].equals("*")) {
                qualifier = "*";
            } else if (eq.length > 2) {
                qualifier = eq[2];
            }
            if (this.metadataExposureService.isHidden(context, schema, element, qualifier) || (values = this.itemService.getMetadata((DSpaceObject)this.item, schema, element, qualifier, "*")) == null || values.size() <= 0) continue;
            String metadataNameClass = "";
            metadataNameClass = qualifier == null || "*".equals(qualifier) || qualifier.isEmpty() ? schema + "_" + element : schema + "_" + element + "_" + qualifier;
            out.print("<tr><td class=\"metadataFieldLabel " + metadataNameClass + "\">");
            String label = null;
            try {
                label = I18nUtil.getMessage((String)("metadata." + ("default".equals(this.style) ? "" : this.style + ".") + (String)field), (Context)context);
            }
            catch (MissingResourceException e) {
                label = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)("metadata." + (String)field));
            }
            out.print(label);
            out.print(":&nbsp;</td><td class=\"metadataFieldValue " + metadataNameClass + "\">");
            if (isDisplay) {
                List displayValues = new ArrayList();
                displayValues = Util.getControlledVocabulariesDisplayValueLocalized((Item)this.item, (List)values, (String)schema, (String)element, (String)qualifier, (Locale)sessionLocale);
                if (displayValues != null && !displayValues.isEmpty()) {
                    for (int d = 0; d < displayValues.size(); ++d) {
                        out.print((String)displayValues.get(d));
                        if (d >= displayValues.size() - 1) continue;
                        out.print(" <br/>");
                    }
                }
                out.print("</td>");
                continue;
            }
            int j = 0;
            for (MetadataValue val : values) {
                if (val == null || val.getValue() == null) continue;
                if (j > 0) {
                    if (isNoBreakLine) {
                        String separator = ConfigurationManager.getProperty((String)"webui.itemdisplay.nobreakline.separator");
                        if (separator == null) {
                            separator = ";&nbsp;";
                        }
                        out.print(separator);
                    } else {
                        out.print("<br />");
                    }
                }
                ++j;
                if (isLink) {
                    out.print("<a href=\"" + val.getValue() + "\">" + Utils.addEntities((String)val.getValue()) + "</a>");
                    continue;
                }
                if (isDate) {
                    DCDate dd = new DCDate(val.getValue());
                    out.print(UIUtil.displayDate((DCDate)dd, (boolean)false, (boolean)false, (HttpServletRequest)((HttpServletRequest)this.pageContext.getRequest())));
                    continue;
                }
                if (isResolver) {
                    String value = val.getValue();
                    if (value.startsWith("http://") || value.startsWith("https://") || value.startsWith("ftp://") || value.startsWith("ftps://")) {
                        out.print("<a href=\"" + value + "\">" + Utils.addEntities((String)value) + "</a>");
                        continue;
                    }
                    String foundUrn = null;
                    if (!"resolver".equals(style)) {
                        foundUrn = style;
                    } else {
                        for (String checkUrn : urn2baseurl.keySet()) {
                            if (!value.startsWith(checkUrn)) continue;
                            foundUrn = checkUrn;
                        }
                    }
                    if (foundUrn != null) {
                        if (value.startsWith(foundUrn + ":")) {
                            value = value.substring(foundUrn.length() + 1);
                        }
                        String url = (String)urn2baseurl.get(foundUrn);
                        out.print("<a href=\"" + url + value + "\">" + Utils.addEntities((String)val.getValue()) + "</a>");
                        continue;
                    }
                    out.print(value);
                    continue;
                }
                if (browseIndex != null) {
                    String value;
                    String argument;
                    MetadataField metadataField = val.getMetadataField();
                    if (val.getAuthority() != null && val.getConfidence() >= this.metadataAuthorityService.getMinConfidence(metadataField)) {
                        argument = "authority";
                        value = val.getAuthority();
                    } else {
                        argument = "value";
                        value = val.getValue();
                    }
                    out.print("<a class=\"" + ("authority".equals(argument) ? "authority " : "") + browseIndex + "\"" + "href=\"" + request.getContextPath() + "/browse?type=" + browseIndex + "&amp;" + argument + "=" + URLEncoder.encode(value, "UTF-8") + "\">" + Utils.addEntities((String)val.getValue()) + "</a>");
                    continue;
                }
                out.print(Utils.addEntities((String)val.getValue()));
            }
            out.println("</td></tr>");
        }
        this.listCollections();
        out.println("</table><br/>");
        this.listBitstreams(context);
        if (ConfigurationManager.getBooleanProperty((String)"webui.licence_bundle.show")) {
            out.println("<br/><br/>");
            this.showLicence();
        }
    }

    private void renderFull() throws IOException, SQLException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Context context = UIUtil.obtainContext((HttpServletRequest)request);
        List values = this.itemService.getMetadata((DSpaceObject)this.item, "*", "*", "*", "*");
        out.println("<div class=\"panel panel-info\"><div class=\"panel-heading\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.full") + "</div>");
        out.println("<table class=\"panel-body table itemDisplayTable\">");
        out.println("<tr><th id=\"s1\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.dcfield") + "</th><th id=\"s2\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.value") + "</th><th id=\"s3\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.lang") + "</th></tr>");
        for (MetadataValue val : values) {
            MetadataField field = val.getMetadataField();
            if (this.metadataExposureService.isHidden(context, field.getMetadataSchema().getName(), field.getElement(), field.getQualifier())) continue;
            out.print("<tr><td headers=\"s1\" class=\"metadataFieldLabel\">");
            out.print(field.getMetadataSchema().getName());
            out.print("." + field.getElement());
            if (field.getQualifier() != null) {
                out.print("." + field.getQualifier());
            }
            out.print("</td><td headers=\"s2\" class=\"metadataFieldValue\">");
            out.print(Utils.addEntities((String)val.getValue()));
            out.print("</td><td headers=\"s3\" class=\"metadataFieldValue\">");
            if (val.getLanguage() == null) {
                out.print("-");
            } else {
                out.print(val.getLanguage());
            }
            out.println("</td></tr>");
        }
        this.listCollections();
        out.println("</table></div><br/>");
        this.listBitstreams(context);
        if (ConfigurationManager.getBooleanProperty((String)"webui.licence_bundle.show")) {
            out.println("<br/><br/>");
            this.showLicence();
        }
    }

    private void listCollections() throws IOException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (this.collections != null) {
            out.print("<tr><td class=\"metadataFieldLabel\">");
            if (this.item.getHandle() == null) {
                out.print(LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.submitted"));
            } else {
                out.print(LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.appears"));
            }
            out.print("</td><td class=\"metadataFieldValue\"" + (this.style.equals("full") ? "colspan=\"2\"" : "") + ">");
            for (int i = 0; i < this.collections.size(); ++i) {
                out.print("<a href=\"");
                out.print(request.getContextPath());
                out.print("/handle/");
                out.print(((Collection)this.collections.get(i)).getHandle());
                out.print("\">");
                out.print(((Collection)this.collections.get(i)).getName());
                out.print("</a><br/>");
            }
            out.println("</td></tr>");
        }
    }

    private void listBitstreams(Context context) throws IOException {
        JspWriter out;
        block30: {
            out = this.pageContext.getOut();
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            out.print("<div class=\"panel panel-info\">");
            out.println("<div class=\"panel-heading\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.files") + "</div>");
            try {
                Bundle bnd;
                List bundles = this.itemService.getBundles(this.item, "ORIGINAL");
                boolean filesExist = false;
                Iterator i$ = bundles.iterator();
                while (i$.hasNext() && !(filesExist = (bnd = (Bundle)i$.next()).getBitstreams().size() > 0)) {
                }
                if (!filesExist) {
                    out.println("<div class=\"panel-body\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.files.no") + "</div>");
                    break block30;
                }
                boolean html = false;
                String handle = this.item.getHandle();
                Bitstream primaryBitstream = null;
                List bunds = this.itemService.getBundles(this.item, "ORIGINAL");
                List thumbs = this.itemService.getBundles(this.item, "THUMBNAIL");
                boolean multiFile = false;
                List allBundles = this.item.getBundles();
                int filecount = 0;
                for (int i = 0; i < allBundles.size() && !multiFile; ++i) {
                    multiFile = (filecount += ((Bundle)allBundles.get(i)).getBitstreams().size()) > 1;
                }
                if (bunds.get(0) != null) {
                    List bits = ((Bundle)bunds.get(0)).getBitstreams();
                    for (int i = 0; i < bits.size() && !html; ++i) {
                        Bitstream b = (Bitstream)bits.get(i);
                        if (!b.equals((Object)((Bundle)bunds.get(0)).getPrimaryBitstream())) continue;
                        html = b.getFormat(context).getMIMEType().equals("text/html");
                        primaryBitstream = b;
                    }
                }
                out.println("<table class=\"table panel-body\"><tr><th id=\"t1\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.file") + "</th>");
                if (multiFile) {
                    out.println("<th id=\"t2\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.description") + "</th>");
                }
                out.println("<th id=\"t3\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.filesize") + "</th><th id=\"t4\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.fileformat") + "</th><th>&nbsp;</th></tr>");
                if (html) {
                    if (handle == null) {
                        handle = "db-id/" + this.item.getID();
                    }
                    out.print("<tr><td headers=\"t1\" class=\"standard break-all\">");
                    out.print("<a target=\"_blank\" href=\"");
                    out.print(request.getContextPath());
                    out.print("/html/");
                    out.print(handle + "/");
                    out.print(UIUtil.encodeBitstreamName((String)primaryBitstream.getName(), (String)"UTF-8"));
                    out.print("\">");
                    out.print(primaryBitstream.getName());
                    out.print("</a>");
                    if (multiFile) {
                        out.print("</td><td headers=\"t2\" class=\"standard break-all\">");
                        String desc = primaryBitstream.getDescription();
                        out.print(desc != null ? desc : "");
                    }
                    out.print("</td><td headers=\"t3\" class=\"standard\">");
                    out.print(UIUtil.formatFileSize((double)primaryBitstream.getSize()));
                    out.print("</td><td headers=\"t4\" class=\"standard\">");
                    out.print(primaryBitstream.getFormatDescription(context));
                    out.print("</td><td class=\"standard\"><a class=\"btn btn-primary\" target=\"_blank\" href=\"");
                    out.print(request.getContextPath());
                    out.print("/html/");
                    out.print(handle + "/");
                    out.print(UIUtil.encodeBitstreamName((String)primaryBitstream.getName(), (String)"UTF-8"));
                    out.print("\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.view") + "</a></td></tr>");
                } else {
                    boolean showRequestCopy = false;
                    if ("all".equalsIgnoreCase(ConfigurationManager.getProperty((String)"request.item.type")) || "logged".equalsIgnoreCase(ConfigurationManager.getProperty((String)"request.item.type")) && context.getCurrentUser() != null) {
                        showRequestCopy = true;
                    }
                    boolean labelResctrictedBitstreams = ConfigurationManager.getBooleanProperty((String)"webui.itemdisplay.label.restricted.bitstreams", (boolean)true);
                    for (Bundle bundle : bundles) {
                        List bitstreams = bundle.getBitstreams();
                        for (Bitstream b : bitstreams) {
                            if (b.getFormat(context).isInternal()) continue;
                            String bsLink = "target=\"_blank\" href=\"" + request.getContextPath();
                            bsLink = handle != null && b.getSequenceID() > 0 ? bsLink + "/bitstream/" + this.item.getHandle() + "/" + b.getSequenceID() + "/" : bsLink + "/retrieve/" + b.getID() + "/";
                            bsLink = bsLink + UIUtil.encodeBitstreamName((String)b.getName(), (String)"UTF-8") + "\">";
                            out.print("<tr><td headers=\"t1\" class=\"standard break-all\">");
                            out.print("<a ");
                            out.print(bsLink);
                            out.print(b.getName());
                            out.print("</a>");
                            boolean anonymousReadable = false;
                            List policies = this.resourcePolicyService.find(context, (DSpaceObject)b, this.groupService.findByName(context, "Anonymous"), 0, -1);
                            ResourcePolicy rp = null;
                            Iterator i$2 = policies.iterator();
                            while (i$2.hasNext()) {
                                ResourcePolicy policy;
                                rp = policy = (ResourcePolicy)i$2.next();
                                if (!this.resourcePolicyService.isDateValid(policy)) continue;
                                anonymousReadable = true;
                                break;
                            }
                            if (rp == null && !anonymousReadable) {
                                Collection parent = null;
                                if (this.workspaceItemService.findByItem(context, this.item) != null) {
                                    parent = this.workspaceItemService.findByItem(context, this.item).getCollection();
                                } else if (this.workflowItemService.findByItem(context, this.item) != null) {
                                    parent = this.workflowItemService.findByItem(context, this.item).getCollection();
                                }
                                if (parent != null) {
                                    boolean bl = anonymousReadable = !this.authorizeService.getPoliciesActionFilter(context, (DSpaceObject)parent, 10).isEmpty();
                                }
                            }
                            if (labelResctrictedBitstreams && !anonymousReadable) {
                                out.print("<br /><i class=\"label label-info\">");
                                if (rp == null || rp.getEndDate() != null || rp.getStartDate() == null) {
                                    out.print(LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.accessRestricted"));
                                } else {
                                    out.print(LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.restrictionUntil"));
                                    out.print(" " + DateFormatUtils.format((Date)rp.getStartDate(), (String)"yyyy-MM-dd"));
                                }
                                out.print("</i>");
                            }
                            if (multiFile) {
                                out.print("</td><td headers=\"t2\" class=\"standard break-all\">");
                                String desc = b.getDescription();
                                out.print(desc != null ? desc : "");
                            }
                            out.print("</td><td headers=\"t3\" class=\"standard\">");
                            out.print(UIUtil.formatFileSize((double)b.getSize()));
                            out.print("</td><td headers=\"t4\" class=\"standard\">");
                            out.print(b.getFormatDescription(context));
                            out.print("</td><td class=\"standard\" align=\"center\">");
                            if (thumbs.size() > 0 && this.showThumbs) {
                                String tName = b.getName() + ".jpg";
                                String tAltText = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.thumbnail");
                                Bitstream tb = this.bundleService.getBitstreamByName((Bundle)thumbs.get(0), tName);
                                if (tb != null && this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)tb, 0)) {
                                    String myPath = request.getContextPath() + "/retrieve/" + tb.getID() + "/" + UIUtil.encodeBitstreamName((String)tb.getName(), (String)"UTF-8");
                                    out.print("<a ");
                                    out.print(bsLink);
                                    out.print("<img src=\"" + myPath + "\" ");
                                    out.print("alt=\"" + tAltText + "\" /></a><br />");
                                }
                            }
                            out.print("<a class=\"btn btn-primary\" ");
                            out.print(bsLink + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.view") + "</a>");
                            try {
                                if (showRequestCopy && !this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)b, 0)) {
                                    out.print("&nbsp;<a class=\"btn btn-success\" href=\"" + request.getContextPath() + "/request-item?handle=" + handle + "&bitstream-id=" + b.getID() + "\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.restrict") + "</a>");
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            out.print("</td></tr>");
                        }
                    }
                }
                out.println("</table>");
            }
            catch (SQLException sqle) {
                throw new IOException(sqle.getMessage(), sqle);
            }
        }
        out.println("</div>");
    }

    private void getThumbSettings() {
        this.showThumbs = ConfigurationManager.getBooleanProperty((String)"webui.item.thumbnail.show");
    }

    private void showLicence() throws IOException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        List bundles = null;
        try {
            bundles = this.itemService.getBundles(this.item, "LICENSE");
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage(), sqle);
        }
        out.println("<table align=\"center\" class=\"table attentionTable\"><tr>");
        out.println("<td class=\"attentionCell\"><p><strong>" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.itemprotected") + "</strong></p>");
        for (Bundle bundle : bundles) {
            List bitstreams = bundle.getBitstreams();
            for (Bitstream b : bitstreams) {
                out.print("<div align=\"center\" class=\"standard\">");
                out.print("<strong><a class=\"btn btn-primary\" target=\"_blank\" href=\"");
                out.print(request.getContextPath());
                out.print("/retrieve/");
                out.print(b.getID() + "/");
                out.print(UIUtil.encodeBitstreamName((String)b.getName(), (String)"UTF-8"));
                out.print("\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.viewlicence") + "</a></strong></div>");
            }
        }
        out.println("</td></tr></table>");
    }

    private String getBrowseField(String field) throws BrowseException {
        for (String indexName : linkedMetadata.keySet()) {
            StringTokenizer bw_dcf = new StringTokenizer((String)linkedMetadata.get(indexName), ".");
            String[] bw_tokens = new String[]{"", "", ""};
            int i = 0;
            while (bw_dcf.hasMoreTokens()) {
                bw_tokens[i] = bw_dcf.nextToken().toLowerCase().trim();
                ++i;
            }
            String bw_schema = bw_tokens[0];
            String bw_element = bw_tokens[1];
            String bw_qualifier = bw_tokens[2];
            StringTokenizer dcf = new StringTokenizer(field, ".");
            String[] tokens = new String[]{"", "", ""};
            int j = 0;
            while (dcf.hasMoreTokens()) {
                tokens[j] = dcf.nextToken().toLowerCase().trim();
                ++j;
            }
            String schema = tokens[0];
            String element = tokens[1];
            String qualifier = tokens[2];
            if (!schema.equals(bw_schema) || !element.equals(bw_element) || (bw_qualifier == null || (qualifier == null || !qualifier.equals(bw_qualifier)) && !bw_qualifier.equals("*")) && (bw_qualifier != null || qualifier != null)) continue;
            return indexName;
        }
        return null;
    }

    static {
        String urn;
        String linkMetadata;
        log = Logger.getLogger(ItemTag.class);
        linkedMetadata = new HashMap();
        int i = 1;
        do {
            if ((linkMetadata = ConfigurationManager.getProperty((String)("webui.browse.link." + i))) != null) {
                String[] linkedMetadataSplit = linkMetadata.split(":");
                String indexName = linkedMetadataSplit[0].trim();
                String metadataName = linkedMetadataSplit[1].trim();
                linkedMetadata.put(indexName, metadataName);
            }
            ++i;
        } while (linkMetadata != null);
        urn2baseurl = new HashMap();
        i = 1;
        do {
            if ((urn = ConfigurationManager.getProperty((String)("webui.resolver." + i + ".urn"))) != null) {
                String baseurl = ConfigurationManager.getProperty((String)("webui.resolver." + i + ".baseurl"));
                if (baseurl != null) {
                    urn2baseurl.put(urn, baseurl);
                } else {
                    log.warn((Object)("Wrong webui.resolver configuration, you need to specify both webui.resolver.<n>.urn and webui.resolver.<n>.baseurl: missing baseurl for n = " + i));
                }
            }
            ++i;
        } while (urn != null);
        if (!urn2baseurl.containsKey("doi")) {
            urn2baseurl.put("doi", DOI_DEFAULT_BASEURL);
        }
        if (!urn2baseurl.containsKey("hdl")) {
            urn2baseurl.put("hdl", HANDLE_DEFAULT_BASEURL);
        }
    }
}

