/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.webui.json.JSONRequest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.license.CCLicenseField;
import org.dspace.license.CCLookup;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class CreativeCommonsJSONRequest
extends JSONRequest {
    private static Logger log = Logger.getLogger(CreativeCommonsJSONRequest.class);
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public void doJSONRequest(Context context, HttpServletRequest req, HttpServletResponse resp) throws AuthorizeException, IOException {
        Gson json = new Gson();
        String selectedLicense = req.getParameter("license");
        ArrayList<CCLicenseField> dto = new ArrayList<CCLicenseField>();
        if (StringUtils.isNotBlank((String)selectedLicense)) {
            CCLookup cclookup = new CCLookup();
            String ccLocale = this.configurationService.getProperty("cc.license.locale");
            String string = ccLocale = StringUtils.isNotBlank((String)ccLocale) ? ccLocale : "en";
            if (cclookup.getLicenseFields(selectedLicense, ccLocale) != null) {
                Collection outerIterator = cclookup.getLicenseFields(selectedLicense, ccLocale);
                for (CCLicenseField cclicensefield : outerIterator) {
                    if (cclicensefield.getId().equals("jurisdiction")) continue;
                    dto.add(cclicensefield);
                }
            }
        }
        JsonElement tree = json.toJsonTree(dto);
        JsonObject jo = new JsonObject();
        jo.add("result", tree);
        resp.getWriter().write(jo.toString());
    }
}

