/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.handle;

import com.google.gson.Gson;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.webui.json.JSONRequest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class HandleJSONResolver
extends JSONRequest {
    private static final Logger log = Logger.getLogger(HandleJSONResolver.class);
    private HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public void doJSONRequest(Context context, HttpServletRequest request, HttpServletResponse resp) throws AuthorizeException, IOException {
        String reqPath = request.getPathInfo().replaceFirst(this.getSubPath() + "/", "");
        if (reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        Gson gson = new Gson();
        String jsonString = "";
        try {
            if (reqPath.startsWith("resolve/")) {
                String handle = reqPath.substring("resolve/".length());
                if (StringUtils.isBlank((String)handle)) {
                    resp.sendError(400);
                    return;
                }
                String url = this.handleService.resolveToURL(context, handle);
                jsonString = url != null ? gson.toJson((Object)new String[]{url}) : gson.toJson(null);
            } else if (reqPath.equals("listprefixes")) {
                ArrayList<String> prefixes = new ArrayList<String>();
                prefixes.add(this.handleService.getPrefix());
                String[] additionalPrefixes = this.configurationService.getArrayProperty("handle.additional.prefixes");
                if (additionalPrefixes != null) {
                    for (String apref : additionalPrefixes) {
                        prefixes.add(apref.trim());
                    }
                }
                jsonString = gson.toJson(prefixes);
            } else if (reqPath.startsWith("listhandles/")) {
                if (this.configurationService.getBooleanProperty("handle.hide.listhandles", true)) {
                    resp.sendError(404);
                    return;
                }
                String prefix = reqPath.substring("listhandles/".length());
                if (StringUtils.isBlank((String)prefix)) {
                    resp.sendError(400);
                    return;
                }
                List handlelist = this.handleService.getHandlesForPrefix(context, prefix);
                jsonString = gson.toJson((Object)handlelist);
            } else {
                resp.sendError(404);
                return;
            }
            resp.getWriter().print(jsonString);
            return;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
    }
}

