/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.components;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.BrowseEngine;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseInfo;
import org.dspace.browse.BrowserScope;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.plugin.CollectionHomeProcessor;
import org.dspace.plugin.PluginException;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;

public class CollectionItemList
implements CollectionHomeProcessor {
    private static String name = ConfigurationManager.getProperty((String)"webui.collectionhome.browse-name");
    private static final int etal = ConfigurationManager.getIntProperty((String)"webui.browse.author-limit", (int)-1);
    private static final int perpage = ConfigurationManager.getIntProperty((String)"webui.collectionhome.perpage", (int)20);
    private static boolean useDateaccessioned = ConfigurationManager.getBooleanProperty((String)"webui.collectionhome.use.dateaccessioned", (boolean)true);
    private static int number = -1;

    public void process(Context context, HttpServletRequest request, HttpServletResponse response, Collection collection) throws PluginException, AuthorizeException {
        int offset = UIUtil.getIntParameter((HttpServletRequest)request, (String)"offset");
        if (offset < 0) {
            offset = 0;
        }
        try {
            BrowseIndex bi = BrowseIndex.getBrowseIndex((String)name);
            if (bi == null || !"item".equals(bi.getDisplayType())) {
                request.setAttribute("show.items", (Object)Boolean.FALSE);
                return;
            }
            BrowserScope scope = new BrowserScope(context);
            scope.setBrowseContainer((DSpaceObject)collection);
            scope.setBrowseIndex(bi);
            scope.setEtAl(etal);
            scope.setOffset(offset);
            scope.setResultsPerPage(perpage);
            if (number != -1) {
                scope.setSortBy(number);
                scope.setOrder("DESC");
            }
            BrowseEngine be = new BrowseEngine(context);
            BrowseInfo binfo = be.browse(scope);
            request.setAttribute("browse.info", (Object)binfo);
            if (binfo.hasResults()) {
                request.setAttribute("show.items", (Object)Boolean.TRUE);
            } else {
                request.setAttribute("show.items", (Object)Boolean.FALSE);
            }
        }
        catch (BrowseException e) {
            request.setAttribute("show.items", (Object)Boolean.FALSE);
        }
    }

    static {
        if (name == null) {
            name = "title";
        }
        if (useDateaccessioned) {
            try {
                for (SortOption option : SortOption.getSortOptions()) {
                    if (!"dateaccessioned".equals(option.getName())) continue;
                    number = option.getNumber();
                    break;
                }
            }
            catch (SortException sortException) {
                // empty catch block
            }
        }
    }
}

