/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.discovery.DiscoverySearchRequestProcessor;
import org.dspace.app.webui.search.SearchProcessorException;
import org.dspace.app.webui.search.SearchRequestProcessor;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.browse.BrowseException;
import org.dspace.browse.IndexBrowse;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.Context;
import org.dspace.core.PluginConfigurationError;
import org.dspace.core.PluginManager;

public class ItemMapServlet
extends DSpaceServlet {
    private SearchRequestProcessor internalLogic;
    private static Logger log = Logger.getLogger(ItemMapServlet.class);

    public void init() {
        try {
            this.internalLogic = (SearchRequestProcessor)PluginManager.getSinglePlugin(SearchRequestProcessor.class);
        }
        catch (PluginConfigurationError e) {
            log.warn((Object)"ItemMapServlet not properly configurated, please configure the SearchRequestProcessor plugin", (Throwable)e);
        }
        if (this.internalLogic == null) {
            this.internalLogic = new DiscoverySearchRequestProcessor();
        }
    }

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws SQLException, ServletException, IOException, AuthorizeException {
        this.doDSPost(context, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws SQLException, ServletException, IOException, AuthorizeException {
        String cancel;
        String jspPage = null;
        int myID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"cid");
        Collection myCollection = Collection.find((Context)context, (int)myID);
        AuthorizeManager.authorizeAction((Context)context, (DSpaceObject)myCollection, (int)11);
        String action = request.getParameter("action");
        if (action == null) {
            action = "";
        }
        if ((cancel = request.getParameter("cancel")) == null) {
            cancel = "";
        }
        if (action.equals("") || !cancel.equals("")) {
            int count_native = 0;
            int count_import = 0;
            HashMap<Integer, Item> myItems = new HashMap<Integer, Item>();
            HashMap<Integer, Collection> myCollections = new HashMap<Integer, Collection>();
            HashMap<Integer, Integer> myCounts = new HashMap<Integer, Integer>();
            try (ItemIterator i = myCollection.getItems();){
                while (i.hasNext()) {
                    Item myItem = i.next();
                    Integer myKey = myItem.getID();
                    if (myItem.isOwningCollection(myCollection)) {
                        ++count_native;
                    } else {
                        ++count_import;
                    }
                    Collection owningCollection = myItem.getOwningCollection();
                    Integer cKey = owningCollection.getID();
                    if (myCollections.containsKey(cKey)) {
                        Integer x = (Integer)myCounts.get(cKey);
                        int myCount = x + 1;
                        myCounts.put(cKey, myCount);
                    } else {
                        myCollections.put(cKey, owningCollection);
                        myCounts.put(cKey, 1);
                    }
                    myItems.put(myKey, myItem);
                }
            }
            myCollections.remove(myCollection.getID());
            request.setAttribute("collection", (Object)myCollection);
            request.setAttribute("count_native", (Object)count_native);
            request.setAttribute("count_import", (Object)count_import);
            request.setAttribute("items", myItems);
            request.setAttribute("collections", myCollections);
            request.setAttribute("collection_counts", myCounts);
            request.setAttribute("all_collections", (Object)Collection.findAll((Context)context));
            request.setAttribute("searchIndices", (Object)this.internalLogic.getSearchIndices());
            request.setAttribute("prefixKey", (Object)this.internalLogic.getI18NKeyPrefix());
            jspPage = "itemmap-main.jsp";
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)jspPage);
        } else if (action.equals("Remove")) {
            String[] itemIDs = request.getParameterValues("item_ids");
            String message = "remove";
            LinkedList<String> removedItems = new LinkedList<String>();
            if (itemIDs == null) {
                message = "none-removed";
            } else {
                for (int j = 0; j < itemIDs.length; ++j) {
                    int i = Integer.parseInt(itemIDs[j]);
                    removedItems.add(itemIDs[j]);
                    Item myItem = Item.find((Context)context, (int)i);
                    if (myItem.isOwningCollection(myCollection)) continue;
                    myCollection.removeItem(myItem);
                    try {
                        IndexBrowse ib = new IndexBrowse(context);
                        ib.indexItem(myItem);
                        continue;
                    }
                    catch (BrowseException e) {
                        log.error((Object)"caught exception: ", (Throwable)e);
                        throw new ServletException((Throwable)e);
                    }
                }
            }
            request.setAttribute("message", (Object)message);
            request.setAttribute("collection", (Object)myCollection);
            request.setAttribute("processedItems", removedItems);
            jspPage = "itemmap-info.jsp";
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)jspPage);
        } else if (action.equals("Add")) {
            String[] itemIDs = request.getParameterValues("item_ids");
            String message = "added";
            LinkedList<String> addedItems = new LinkedList<String>();
            if (itemIDs == null) {
                message = "none-selected";
            } else {
                for (int j = 0; j < itemIDs.length; ++j) {
                    int i = Integer.parseInt(itemIDs[j]);
                    Item myItem = Item.find((Context)context, (int)i);
                    if (!AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)myItem, (int)0) || myItem.isOwningCollection(myCollection)) continue;
                    myCollection.addItem(myItem);
                    try {
                        IndexBrowse ib = new IndexBrowse(context);
                        ib.indexItem(myItem);
                    }
                    catch (BrowseException e) {
                        log.error((Object)"caught exception: ", (Throwable)e);
                        throw new ServletException((Throwable)e);
                    }
                    addedItems.add(itemIDs[j]);
                }
            }
            request.setAttribute("message", (Object)message);
            request.setAttribute("collection", (Object)myCollection);
            request.setAttribute("processedItems", addedItems);
            jspPage = "itemmap-info.jsp";
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)jspPage);
        } else {
            if (action.equals("search")) {
                request.setAttribute("collection", (Object)myCollection);
                try {
                    this.internalLogic.doItemMapSearch(context, request, response);
                }
                catch (SearchProcessorException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new ServletException(e.getMessage(), (Throwable)e);
                }
            }
            if (action.equals("browse")) {
                int t = UIUtil.getIntParameter((HttpServletRequest)request, (String)"t");
                Collection targetCollection = Collection.find((Context)context, (int)t);
                HashMap<Integer, Item> items = new HashMap<Integer, Item>();
                try (ItemIterator i = myCollection.getItems();){
                    while (i.hasNext()) {
                        Item myItem = i.next();
                        if (!myItem.isOwningCollection(targetCollection)) continue;
                        Integer myKey = myItem.getID();
                        items.put(myKey, myItem);
                    }
                }
                request.setAttribute("collection", (Object)myCollection);
                request.setAttribute("browsetext", (Object)targetCollection.getMetadata("name"));
                request.setAttribute("items", items);
                request.setAttribute("browsetype", (Object)"Remove");
                jspPage = "itemmap-browse.jsp";
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)jspPage);
            }
        }
        context.complete();
    }
}

