/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class ViewWorkspaceItemServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(ViewWorkspaceItemServlet.class);

    protected void doDSGet(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSPost(c, request, response);
    }

    protected void doDSPost(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_error");
        if (button.equals("submit_view") || button.equals("submit_full") || button.equals("submit_simple")) {
            this.showMainPage(c, request, response);
        } else {
            this.showErrorPage(c, request, response);
        }
    }

    private void showMainPage(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        int wsItemID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"workspace_id");
        WorkspaceItem wsItem = WorkspaceItem.find((Context)c, (int)wsItemID);
        Item item = wsItem.getItem();
        Collection[] collections = new Collection[]{wsItem.getCollection()};
        AuthorizeManager.authorizeAction((Context)c, (DSpaceObject)item, (int)0);
        log.info((Object)LogManager.getHeader((Context)c, (String)"View Workspace Item Metadata", (String)("workspace_item_id=" + wsItemID)));
        boolean displayAll = false;
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_simple");
        if (button.equalsIgnoreCase("submit_full")) {
            displayAll = true;
        }
        request.setAttribute("display.all", (Object)displayAll);
        request.setAttribute("item", (Object)item);
        request.setAttribute("collections", (Object)collections);
        request.setAttribute("workspace_id", (Object)wsItem.getID());
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/display-item.jsp");
    }

    private void showErrorPage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        int wsItemID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"workspace_id");
        log.error((Object)LogManager.getHeader((Context)context, (String)"View Workspace Item Metadata Failed", (String)("workspace_item_id=" + wsItemID)));
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/workspace/wsv-error.jsp");
    }
}

