/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.handle.HandleManager;
import org.dspace.search.DSQuery;
import org.dspace.search.QueryArgs;
import org.dspace.search.QueryResults;

/*
 * Exception performing whole class analysis ignored.
 */
public class ControlledVocabularySearchServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(ControlledVocabularySearchServlet.class);
    private static final String SEARCH_JSP = "/controlledvocabulary/search.jsp";
    private static final String RESULTS_JSP = "/controlledvocabulary/results.jsp";

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String action;
        String string = action = request.getParameter("action") == null ? "" : request.getParameter("action");
        if (action.equals("search")) {
            List keywords = this.extractKeywords(request);
            String query = ControlledVocabularySearchServlet.join((List)keywords, (String)" or ");
            this.doSearch(context, request, query);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/controlledvocabulary/results.jsp");
        } else if (action.equals("filter")) {
            String filter = request.getParameter("filter");
            request.getSession().setAttribute("conceptsearch.filter", (Object)filter);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/controlledvocabulary/search.jsp");
        } else {
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/controlledvocabulary/search.jsp");
        }
    }

    private List<String> extractKeywords(HttpServletRequest request) {
        ArrayList<String> keywords = new ArrayList<String>();
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String element = (String)enumeration.nextElement();
            if (!element.startsWith("cb_")) continue;
            keywords.add("\"" + request.getParameter(element) + "\"");
        }
        return keywords;
    }

    private void doSearch(Context context, HttpServletRequest request, String query) throws IOException, SQLException {
        DSpaceObject o;
        String myhandle;
        int i;
        int start = UIUtil.getIntParameter((HttpServletRequest)request, (String)"start");
        String advanced = request.getParameter("advanced");
        if (start < 0) {
            start = 0;
        }
        ArrayList<String> itemHandles = new ArrayList<String>();
        ArrayList<String> collectionHandles = new ArrayList<String>();
        ArrayList<String> communityHandles = new ArrayList<String>();
        QueryResults qResults = null;
        QueryArgs qArgs = new QueryArgs();
        if (advanced != null) {
            query = qArgs.buildQuery(request);
        }
        if (query == null) {
            query = "";
        }
        String logInfo = "";
        Community community = UIUtil.getCommunityLocation((HttpServletRequest)request);
        Collection collection = UIUtil.getCollectionLocation((HttpServletRequest)request);
        qArgs.setQuery(query);
        qArgs.setStart(start);
        if (collection != null) {
            logInfo = "collection_id=" + collection.getID() + ",";
            request.setAttribute("community", (Object)community);
            request.setAttribute("collection", (Object)collection);
            qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs, (Collection)collection);
        } else if (community != null) {
            logInfo = "community_id=" + community.getID() + ",";
            request.setAttribute("community", (Object)community);
            request.setAttribute("collection.array", (Object)community.getCollections());
            qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs, (Community)community);
        } else {
            Community[] communities = Community.findAll((Context)context);
            request.setAttribute("community.array", (Object)communities);
            qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs);
        }
        block5: for (int i2 = 0; i2 < qResults.getHitHandles().size(); ++i2) {
            String myHandle = (String)qResults.getHitHandles().get(i2);
            Integer myType = (Integer)qResults.getHitTypes().get(i2);
            switch (myType) {
                case 2: {
                    itemHandles.add(myHandle);
                    continue block5;
                }
                case 3: {
                    collectionHandles.add(myHandle);
                    continue block5;
                }
                case 4: {
                    communityHandles.add(myHandle);
                }
            }
        }
        int numCommunities = communityHandles.size();
        int numCollections = collectionHandles.size();
        int numItems = itemHandles.size();
        Community[] resultsCommunities = new Community[numCommunities];
        Collection[] resultsCollections = new Collection[numCollections];
        Item[] resultsItems = new Item[numItems];
        for (i = 0; i < numItems; ++i) {
            myhandle = (String)itemHandles.get(i);
            o = HandleManager.resolveToObject((Context)context, (String)myhandle);
            resultsItems[i] = (Item)o;
            if (resultsItems[i] != null) continue;
            throw new SQLException("Query \"" + query + "\" returned unresolvable handle: " + myhandle);
        }
        for (i = 0; i < collectionHandles.size(); ++i) {
            myhandle = (String)collectionHandles.get(i);
            o = HandleManager.resolveToObject((Context)context, (String)myhandle);
            resultsCollections[i] = (Collection)o;
            if (resultsCollections[i] != null) continue;
            throw new SQLException("Query \"" + query + "\" returned unresolvable handle: " + myhandle);
        }
        for (i = 0; i < communityHandles.size(); ++i) {
            myhandle = (String)communityHandles.get(i);
            o = HandleManager.resolveToObject((Context)context, (String)myhandle);
            resultsCommunities[i] = (Community)o;
            if (resultsCommunities[i] != null) continue;
            throw new SQLException("Query \"" + query + "\" returned unresolvable handle: " + myhandle);
        }
        log.info((Object)LogManager.getHeader((Context)context, (String)"search", (String)(logInfo + "query=\"" + query + "\",results=(" + resultsCommunities.length + "," + resultsCollections.length + "," + resultsItems.length + ")")));
        int pageTotal = 1 + (qResults.getHitCount() - 1) / qResults.getPageSize();
        int pageCurrent = 1 + qResults.getStart() / qResults.getPageSize();
        int pageLast = pageCurrent + 9 > pageTotal ? pageTotal : pageCurrent + 9;
        int pageFirst = pageCurrent - 9 > 1 ? pageCurrent - 9 : 1;
        request.setAttribute("items", (Object)resultsItems);
        request.setAttribute("communities", (Object)resultsCommunities);
        request.setAttribute("collections", (Object)resultsCollections);
        request.setAttribute("pagetotal", (Object)pageTotal);
        request.setAttribute("pagecurrent", (Object)pageCurrent);
        request.setAttribute("pagelast", (Object)pageLast);
        request.setAttribute("pagefirst", (Object)pageFirst);
        request.setAttribute("queryresults", (Object)qResults);
        request.setAttribute("query", (Object)query);
    }

    public static String join(List<String> list, String separator) {
        StringBuilder result = new StringBuilder();
        for (String entry : list) {
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(entry);
        }
        return result.toString();
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSGet(context, request, response);
    }
}

