/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.jsptag;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.core.ConfigurationManager;

public class ItemPreviewTag
extends TagSupport {
    private transient Item item;
    private static final long serialVersionUID = -5535762797556685631L;

    public int doStartTag() throws JspException {
        if (!ConfigurationManager.getBooleanProperty((String)"webui.preview.enabled")) {
            return 0;
        }
        try {
            this.showPreview();
        }
        catch (SQLException sqle) {
            throw new JspException((Throwable)sqle);
        }
        catch (IOException ioe) {
            throw new JspException((Throwable)ioe);
        }
        return 0;
    }

    public void setItem(Item itemIn) {
        this.item = itemIn;
    }

    private void showPreview() throws SQLException, IOException {
        JspWriter out = this.pageContext.getOut();
        Bundle[] bundles = this.item.getBundles("BRANDED_PREVIEW");
        if (bundles.length > 0) {
            int i;
            Metadatum[] dcValue;
            Bitstream[] bitstreams = bundles[0].getBitstreams();
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            out.println("<br/><p align=\"center\">");
            out.println("<img src=\"" + request.getContextPath() + "/retrieve/" + bitstreams[0].getID() + "/" + UIUtil.encodeBitstreamName((String)bitstreams[0].getName(), (String)"UTF-8") + "\"/>");
            String s = ConfigurationManager.getProperty((String)"webui.preview.dc");
            if (s != null && (dcValue = (i = s.indexOf(46)) == -1 ? this.item.getDC(s, "*", "*") : this.item.getDC(s.substring(0, 1), s.substring(i + 1), "*")).length > 0) {
                out.println("<br/>" + dcValue[0].value);
            }
            out.println("</p>");
        }
    }

    public void release() {
        this.item = null;
    }
}

