/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.app.webui.servlet.SubmissionController;
import org.dspace.app.webui.submit.JSPStep;
import org.dspace.app.webui.submit.JSPStepManager;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.license.CreativeCommons;

public class JSPCCLicenseStep
extends JSPStep {
    private static final String CC_LICENSE_JSP = "/submit/creative-commons.jsp";
    private static final String LICENSE_REJECT_JSP = "/submit/license-rejected.jsp";
    private static Logger log = Logger.getLogger(JSPCCLicenseStep.class);

    public void doPreProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        Item item = subInfo.getSubmissionItem().getItem();
        boolean exists = CreativeCommons.hasLicense((Context)context, (Item)item);
        request.setAttribute("cclicense.exists", (Object)exists);
        JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)CC_LICENSE_JSP);
    }

    public void doPostProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, int status) throws ServletException, IOException, SQLException, AuthorizeException {
        String buttonPressed = Util.getSubmitButton((HttpServletRequest)request, (String)"submit_cancel");
        if (buttonPressed.equals("submit_reject")) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"reject_license", (String)subInfo.getSubmissionLogInfo()));
            if (!subInfo.isInWorkflow() && SubmissionController.getStepReached((SubmissionInfo)subInfo) <= 1) {
                WorkspaceItem wi = (WorkspaceItem)subInfo.getSubmissionItem();
                wi.deleteAll();
                context.commit();
            }
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)LICENSE_REJECT_JSP);
        }
    }

    public String getReviewJSP(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) {
        return "";
    }
}

