/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.Utils;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;
import org.dspace.utils.DSpace;

public class RetrieveServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(RetrieveServlet.class);
    private int threshold;

    public void init(ServletConfig arg0) throws ServletException {
        super.init(arg0);
        this.threshold = ConfigurationManager.getIntProperty((String)"webui.content_disposition_threshold");
    }

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        Bitstream bitstream = null;
        boolean displayLicense = ConfigurationManager.getBooleanProperty((String)"webui.licence_bundle.show", (boolean)false);
        boolean isLicense = false;
        String idString = request.getPathInfo();
        if (idString != null) {
            int slashIndex;
            if (idString.startsWith("/")) {
                idString = idString.substring(1);
            }
            if ((slashIndex = idString.indexOf(47)) != -1) {
                idString = idString.substring(0, slashIndex);
            }
            try {
                int id = Integer.parseInt(idString);
                bitstream = Bitstream.find((Context)context, (int)id);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (bitstream != null) {
            Bundle bundle;
            Bundle bundle2 = bundle = bitstream.getBundles().length > 0 ? bitstream.getBundles()[0] : null;
            if (bundle != null && bundle.getName().equals("LICENSE") && bitstream.getName().equals("license.txt")) {
                isLicense = true;
            }
            if (isLicense && !displayLicense && !AuthorizeManager.isAdmin((Context)context)) {
                throw new AuthorizeException();
            }
            log.info((Object)LogManager.getHeader((Context)context, (String)"view_bitstream", (String)("bitstream_id=" + bitstream.getID())));
            new DSpace().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, request, context, (DSpaceObject)bitstream));
            InputStream is = bitstream.retrieve();
            response.setContentType(bitstream.getFormat().getMIMEType());
            response.setHeader("Content-Length", String.valueOf(bitstream.getSize()));
            if (this.threshold != -1 && bitstream.getSize() >= (long)this.threshold) {
                UIUtil.setBitstreamDisposition((String)bitstream.getName(), (HttpServletRequest)request, (HttpServletResponse)response);
            }
            Utils.bufferedCopy((InputStream)is, (OutputStream)response.getOutputStream());
            is.close();
            response.getOutputStream().flush();
        } else {
            log.info((Object)LogManager.getHeader((Context)context, (String)"view_bitstream", (String)("invalid_bitstream_id=" + idString)));
            JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)idString, (int)0);
        }
    }
}

