/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.browse.BrowseEngine;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseInfo;
import org.dspace.browse.BrowserScope;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.discovery.configuration.TagCloudConfiguration;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;
import org.dspace.utils.DSpace;

public abstract class AbstractBrowserServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(AbstractBrowserServlet.class);

    protected BrowserScope getBrowserScopeForRequest(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        try {
            String type = request.getParameter("type");
            String order = request.getParameter("order");
            String value = request.getParameter("value");
            String valueLang = request.getParameter("value_lang");
            String month = request.getParameter("month");
            String year = request.getParameter("year");
            String startsWith = request.getParameter("starts_with");
            String valueFocus = request.getParameter("vfocus");
            String valueFocusLang = request.getParameter("vfocus_lang");
            String authority = request.getParameter("authority");
            int focus = UIUtil.getIntParameter((HttpServletRequest)request, (String)"focus");
            int offset = UIUtil.getIntParameter((HttpServletRequest)request, (String)"offset");
            int resultsperpage = UIUtil.getIntParameter((HttpServletRequest)request, (String)"rpp");
            int sortBy = UIUtil.getIntParameter((HttpServletRequest)request, (String)"sort_by");
            int etAl = UIUtil.getIntParameter((HttpServletRequest)request, (String)"etal");
            Collection collection = null;
            Community community = null;
            collection = UIUtil.getCollectionLocation((HttpServletRequest)request);
            if (collection == null) {
                community = UIUtil.getCommunityLocation((HttpServletRequest)request);
            }
            BrowseIndex bi = null;
            if (type != null && !"".equals(type)) {
                bi = BrowseIndex.getBrowseIndex((String)type);
            }
            if (bi == null) {
                bi = sortBy > 0 ? BrowseIndex.getBrowseIndex((SortOption)SortOption.getSortOption((int)sortBy)) : BrowseIndex.getBrowseIndex((SortOption)SortOption.getDefaultSortOption());
            }
            if (bi != null && sortBy == -1) {
                SortOption so = bi.getSortOption();
                if (so != null) {
                    sortBy = so.getNumber();
                }
            } else if (bi != null && bi.isItemIndex() && !bi.isInternalIndex()) {
                BrowseIndex newBi;
                SortOption bso = bi.getSortOption();
                SortOption so = SortOption.getSortOption((int)sortBy);
                if (bso != null && bso.equals(so) && (newBi = BrowseIndex.getBrowseIndex((SortOption)so)) != null) {
                    bi = newBi;
                    type = bi.getName();
                }
            }
            if (order == null && bi != null) {
                order = bi.getDefaultOrder();
            }
            if (offset < 0) {
                offset = 0;
            }
            if (resultsperpage < 0 && !bi.isTagCloudEnabled()) {
                resultsperpage = 20;
            }
            if (year != null && !"".equals(year) && !"-1".equals(year)) {
                startsWith = year;
                if (month != null && !"-1".equals(month) && !"".equals(month)) {
                    if ("ASC".equals(order)) {
                        month = Integer.toString(Integer.parseInt(month) - 1);
                    }
                    if (month.length() == 1) {
                        month = "0" + month;
                    }
                    startsWith = year + "-" + month;
                    if ("ASC".equals(order)) {
                        startsWith = startsWith + "-32";
                    }
                }
            }
            int level = 0;
            if (value != null || authority != null) {
                level = 1;
            }
            if (sortBy == -1) {
                sortBy = 0;
            }
            if (etAl == -1) {
                int limitLine = ConfigurationManager.getIntProperty((String)"webui.browse.author-limit");
                if (limitLine != 0) {
                    etAl = limitLine;
                }
            } else if (etAl == 0) {
                etAl = -1;
            }
            String comHandle = "n/a";
            if (community != null) {
                comHandle = community.getHandle();
            }
            String colHandle = "n/a";
            if (collection != null) {
                colHandle = collection.getHandle();
            }
            String arguments = "type=" + type + ",order=" + order + ",value=" + value + ",month=" + month + ",year=" + year + ",starts_with=" + startsWith + ",vfocus=" + valueFocus + ",focus=" + focus + ",rpp=" + resultsperpage + ",sort_by=" + sortBy + ",community=" + comHandle + ",collection=" + colHandle + ",level=" + level + ",etal=" + etAl;
            log.info((Object)LogManager.getHeader((Context)context, (String)"browse", (String)arguments));
            BrowserScope scope = new BrowserScope(context);
            scope.setBrowseIndex(bi);
            scope.setOrder(order);
            scope.setFilterValue(value != null ? value : authority);
            scope.setFilterValueLang(valueLang);
            scope.setJumpToItem(focus);
            scope.setJumpToValue(valueFocus);
            scope.setJumpToValueLang(valueFocusLang);
            scope.setStartsWith(startsWith);
            scope.setOffset(offset);
            scope.setResultsPerPage(resultsperpage);
            scope.setSortBy(sortBy);
            scope.setBrowseLevel(level);
            scope.setEtAl(etAl);
            scope.setAuthorityValue(authority);
            if (community != null) {
                scope.setBrowseContainer((DSpaceObject)community);
            } else if (collection != null) {
                scope.setBrowseContainer((DSpaceObject)collection);
            }
            if (bi != null && bi.isMetadataIndex() && scope.isSecondLevel() && scope.getSortBy() <= 0) {
                scope.setSortBy(1);
            }
            return scope;
        }
        catch (SortException se) {
            log.error((Object)"caught exception: ", (Throwable)se);
            throw new ServletException((Throwable)se);
        }
        catch (BrowseException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void processBrowse(Context context, BrowserScope scope, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        try {
            BrowseIndex bi = scope.getBrowseIndex();
            BrowseEngine be = new BrowseEngine(context);
            BrowseInfo binfo = be.browse(scope);
            request.setAttribute("browse.info", (Object)binfo);
            if (AuthorizeManager.isAdmin((Context)context)) {
                request.setAttribute("admin_button", (Object)Boolean.TRUE);
            }
            if (binfo.hasResults()) {
                if (bi.isMetadataIndex() && !scope.isSecondLevel()) {
                    if (bi.isTagCloudEnabled()) {
                        TagCloudConfiguration tagCloudConfiguration = (TagCloudConfiguration)new DSpace().getServiceManager().getServiceByName("browseTagCloudConfiguration", TagCloudConfiguration.class);
                        if (tagCloudConfiguration == null) {
                            tagCloudConfiguration = new TagCloudConfiguration();
                        }
                        request.setAttribute("tagCloudConfig", (Object)tagCloudConfiguration);
                    }
                    this.showSinglePage(context, request, response);
                } else {
                    this.showFullPage(context, request, response);
                }
            } else {
                this.showNoResultsPage(context, request, response);
            }
        }
        catch (BrowseException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected abstract void showError(Context var1, HttpServletRequest var2, HttpServletResponse var3) throws ServletException, IOException, SQLException, AuthorizeException;

    protected abstract void showNoResultsPage(Context var1, HttpServletRequest var2, HttpServletResponse var3) throws ServletException, IOException, SQLException, AuthorizeException;

    protected abstract void showSinglePage(Context var1, HttpServletRequest var2, HttpServletResponse var3) throws ServletException, IOException, SQLException, AuthorizeException;

    protected abstract void showFullPage(Context var1, HttpServletRequest var2, HttpServletResponse var3) throws ServletException, IOException, SQLException, AuthorizeException;
}

