/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.jsptag;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.dspace.app.util.CollectionDropDown;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.Context;

public class SelectCollectionTag
extends TagSupport {
    private String klass;
    private String name;
    private String id;
    private int collection = -1;

    public int doStartTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        StringBuffer sb = new StringBuffer();
        try {
            HttpServletRequest hrq = (HttpServletRequest)this.pageContext.getRequest();
            Context context = UIUtil.obtainContext((HttpServletRequest)hrq);
            LinkedHashMap commCollList = new LinkedHashMap();
            for (Community topcommunity : Community.findAllTop((Context)context)) {
                for (Collection collection : topcommunity.getCollections()) {
                    List clist = null;
                    clist = commCollList.containsKey(topcommunity) ? (List)commCollList.get(topcommunity) : new ArrayList();
                    clist.add(collection);
                    commCollList.put(topcommunity, clist);
                }
                for (Collection collection : topcommunity.getSubcommunities()) {
                    this.addCommCollList((Community)collection, commCollList);
                }
            }
            sb.append("<select");
            if (this.name != null) {
                sb.append(" name=\"").append(this.name).append("\"");
            }
            if (this.klass != null) {
                sb.append(" class=\"").append(this.klass).append("\"");
            }
            if (this.id != null) {
                sb.append(" id=\"").append(this.id).append("\"");
            }
            sb.append(">\n");
            ResourceBundle msgs = ResourceBundle.getBundle("Messages", context.getCurrentLocale());
            String firstOption = msgs.getString("jsp.submit.start-lookup-submission.select.collection.defaultoption");
            sb.append("<option value=\"-1\"");
            if (this.collection == -1) {
                sb.append(" selected=\"selected\"");
            }
            sb.append(">").append(firstOption).append("</option>\n");
            for (Community comm : commCollList.keySet()) {
                for (Collection coll : (List)commCollList.get(comm)) {
                    sb.append("<option value=\"").append(coll.getID()).append("\"");
                    if (this.collection == coll.getID()) {
                        sb.append(" selected=\"selected\"");
                    }
                    sb.append(">").append(CollectionDropDown.collectionPath((Collection)coll)).append("</option>\n");
                }
            }
            sb.append("</select>\n");
            out.print(sb.toString());
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        catch (SQLException e) {
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    private void addCommCollList(Community community, Map<Community, List<Collection>> commCollList) throws SQLException {
        for (Collection collection : community.getCollections()) {
            List<Object> clist = null;
            clist = commCollList.containsKey(community) ? commCollList.get(community) : new ArrayList();
            clist.add(collection);
            commCollList.put(community, clist);
        }
        for (Collection collection : community.getSubcommunities()) {
            this.addCommCollList((Community)collection, commCollList);
        }
    }

    private String getCommName(Community community) throws SQLException {
        Community[] parents;
        StringBuffer sb = new StringBuffer("");
        for (Community parent : parents = community.getAllParents()) {
            sb.insert(0, parent.getMetadata("name") + "/");
        }
        sb.append(community.getMetadata("name"));
        return sb.toString().substring(1);
    }

    public String getKlass() {
        return this.klass;
    }

    public void setKlass(String klass) {
        this.klass = klass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getCollection() {
        return this.collection;
    }

    public void setCollection(int collection) {
        this.collection = collection;
    }

    public void release() {
        this.klass = null;
        this.name = null;
        this.id = null;
        this.collection = -1;
    }
}

