/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.jsptag;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;
import org.dspace.app.webui.jsptag.ControlledVocabularyTag;
import org.dspace.app.webui.util.XMLUtil;
import org.dspace.core.ConfigurationManager;
import org.w3c.dom.Document;

/*
 * Exception performing whole class analysis ignored.
 */
public class ControlledVocabularyTag
extends TagSupport {
    private static final String CONTROLLEDVOCABULARY_JSPTAG = "/controlledvocabulary/controlledvocabularyTag.jsp";
    private static Logger log = Logger.getLogger(ControlledVocabularyTag.class);
    private String filter;
    private boolean allowMultipleSelection;
    private String vocabulary;
    public Map<String, Document> controlledVocabularies;

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String vocabulariesPath = ConfigurationManager.getProperty((String)"dspace.dir") + "/config/controlled-vocabularies/";
        String addonBaseDirectory = this.pageContext.getServletContext().getRealPath("") + "/controlledvocabulary/";
        String vocabularyPrunningXSLT = addonBaseDirectory + "vocabularyprune.xsl";
        String controlledVocabulary2HtmlXSLT = addonBaseDirectory + "vocabulary2html.xsl";
        this.controlledVocabularies = (Map)this.pageContext.getServletContext().getAttribute("controlledvocabulary.controlledVocabularies");
        if (this.controlledVocabularies == null) {
            this.controlledVocabularies = ControlledVocabularyTag.loadControlledVocabularies((String)vocabulariesPath);
            this.pageContext.getServletContext().setAttribute("controlledvocabulary.controlledVocabularies", (Object)this.controlledVocabularies);
        }
        try {
            Map prunnedVocabularies = this.needsFiltering() ? this.filterVocabularies(this.controlledVocabularies, vocabularyPrunningXSLT) : this.controlledVocabularies;
            String html = "";
            html = this.vocabulary != null && !this.vocabulary.equals("") ? this.renderVocabularyAsHTML((Document)prunnedVocabularies.get(this.vocabulary + ".xml"), controlledVocabulary2HtmlXSLT, this.isAllowMultipleSelection(), request.getContextPath()) : this.renderVocabulariesAsHTML(prunnedVocabularies, controlledVocabulary2HtmlXSLT, this.isAllowMultipleSelection(), request.getContextPath());
            request.getSession().setAttribute("controlledvocabulary.vocabularyHTML", (Object)html);
            this.pageContext.include("/controlledvocabulary/controlledvocabularyTag.jsp");
        }
        catch (Exception e) {
            log.warn((Object)"Exception", (Throwable)e);
        }
        return 0;
    }

    public int doEndTag() {
        return 6;
    }

    private boolean needsFiltering() {
        return this.getFilter() != null && this.getFilter().length() > 0;
    }

    private String renderVocabulariesAsHTML(Map<String, Document> vocabularies, String xslt, boolean allowMultipleSelection, String contextPath) {
        StringBuilder result = new StringBuilder();
        for (Document controlledVocabularyXML : vocabularies.values()) {
            result.append(this.renderVocabularyAsHTML(controlledVocabularyXML, xslt, allowMultipleSelection, contextPath));
        }
        return result.toString();
    }

    private Map<String, Document> filterVocabularies(Map<String, Document> vocabularies, String vocabularyPrunningXSLT) {
        HashMap<String, Document> prunnedVocabularies = new HashMap<String, Document>();
        for (Map.Entry<String, Document> entry : vocabularies.entrySet()) {
            prunnedVocabularies.put(entry.getKey(), this.filterVocabulary(entry.getValue(), vocabularyPrunningXSLT, this.getFilter()));
        }
        return prunnedVocabularies;
    }

    public String renderVocabularyAsHTML(Document vocabulary, String controlledVocabulary2HtmlXSLT, boolean allowMultipleSelection, String contextPath) {
        if (vocabulary == null) {
            return "";
        }
        String result = "";
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("allowMultipleSelection", allowMultipleSelection ? "yes" : "no");
            parameters.put("contextPath", contextPath);
            result = XMLUtil.transformDocumentAsString((Document)vocabulary, parameters, (String)controlledVocabulary2HtmlXSLT);
        }
        catch (Exception e) {
            log.error((Object)"Error rendering HTML", (Throwable)e);
        }
        return result;
    }

    public Document filterVocabulary(Document vocabulary, String vocabularyPrunningXSLT, String filter) {
        if (vocabulary == null) {
            return null;
        }
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("filter", filter);
            return XMLUtil.transformDocument((Document)vocabulary, parameters, (String)vocabularyPrunningXSLT);
        }
        catch (Exception e) {
            log.error((Object)"Error filtering vocabulary", (Throwable)e);
            return null;
        }
    }

    private static Map<String, Document> loadControlledVocabularies(String directory) {
        HashMap<String, Document> controlledVocabularies = new HashMap<String, Document>();
        File dir = new File(directory);
        1 filter = new /* Unavailable Anonymous Inner Class!! */;
        String[] children = dir.list((FilenameFilter)filter);
        if (children != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                String filename = children[i];
                try {
                    Document controlledVocabulary = XMLUtil.loadXML((String)(directory + filename));
                    controlledVocabularies.put(filename, controlledVocabulary);
                    log.warn((Object)("Loaded vocabulary: " + filename));
                    continue;
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to load vocabulary from " + filename), (Throwable)e);
                }
            }
        } else {
            log.warn((Object)"Could not find any vocabularies...");
        }
        return controlledVocabularies;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public boolean isAllowMultipleSelection() {
        return this.allowMultipleSelection;
    }

    public void setAllowMultipleSelection(boolean allowMultipleSelection) {
        this.allowMultipleSelection = allowMultipleSelection;
    }

    public String getVocabulary() {
        return this.vocabulary;
    }

    public void setVocabulary(String vocabulary) {
        this.vocabulary = vocabulary;
    }
}

