/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.handle;

import com.google.gson.Gson;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.webui.json.JSONRequest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;

public class HandleJSONResolver
extends JSONRequest {
    private static final Logger log = Logger.getLogger(HandleJSONResolver.class);

    public void doJSONRequest(Context context, HttpServletRequest request, HttpServletResponse resp) throws AuthorizeException, IOException {
        String reqPath = request.getPathInfo().replaceFirst(this.getSubPath() + "/", "");
        if (reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        Gson gson = new Gson();
        String jsonString = "";
        try {
            if (reqPath.startsWith("resolve/")) {
                String handle = reqPath.substring("resolve/".length());
                if (StringUtils.isBlank((String)handle)) {
                    resp.sendError(400);
                    return;
                }
                String url = HandleManager.resolveToURL((Context)context, (String)handle);
                jsonString = url != null ? gson.toJson((Object)new String[]{url}) : gson.toJson(null);
            } else if (reqPath.equals("listprefixes")) {
                ArrayList<String> prefixes = new ArrayList<String>();
                prefixes.add(HandleManager.getPrefix());
                String additionalPrefixes = ConfigurationManager.getProperty((String)"handle.additional.prefixes");
                if (StringUtils.isNotBlank((String)additionalPrefixes)) {
                    for (String apref : additionalPrefixes.split(",")) {
                        prefixes.add(apref.trim());
                    }
                }
                jsonString = gson.toJson(prefixes);
            } else if (reqPath.startsWith("listhandles/")) {
                if (ConfigurationManager.getBooleanProperty((String)"handle.hide.listhandles", (boolean)true)) {
                    resp.sendError(404);
                    return;
                }
                String prefix = reqPath.substring("listhandles/".length());
                if (StringUtils.isBlank((String)prefix)) {
                    resp.sendError(400);
                    return;
                }
                List handlelist = HandleManager.getHandlesForPrefix((Context)context, (String)prefix);
                jsonString = gson.toJson((Object)handlelist);
            } else {
                resp.sendError(404);
                return;
            }
            resp.getWriter().print(jsonString);
            return;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
    }
}

