/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.VersioningService;
import org.dspace.workflow.WorkflowItem;

/*
 * Exception performing whole class analysis ignored.
 */
public class VersionUtil {
    public static Integer processCreateNewVersion(Context context, int itemID, String summary) throws SQLException, AuthorizeException, IOException {
        try {
            Item item = Item.find((Context)context, (int)itemID);
            if (AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)item, (int)1) || item.canEdit()) {
                VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
                Version version = versioningService.createNewVersion(context, itemID, summary);
                WorkspaceItem wsi = WorkspaceItem.findByItem((Context)context, (Item)version.getItem());
                context.commit();
                return wsi.getID();
            }
        }
        catch (Exception ex) {
            context.abort();
            throw new RuntimeException(ex);
        }
        return null;
    }

    public static void processUpdateVersion(Context context, int itemID, String summary) throws SQLException, AuthorizeException, IOException {
        try {
            Item item = Item.find((Context)context, (int)itemID);
            if (AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)item, (int)1)) {
                VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
                versioningService.updateVersion(context, itemID, summary);
                context.commit();
            }
        }
        catch (Exception ex) {
            if (context != null && context.isValid()) {
                context.abort();
            }
            throw new RuntimeException(ex);
        }
    }

    public static void processRestoreVersion(Context context, int versionID, String summary) throws SQLException, AuthorizeException, IOException {
        try {
            VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
            versioningService.restoreVersion(context, versionID, summary);
            context.commit();
        }
        catch (Exception ex) {
            if (context != null && context.isValid()) {
                context.abort();
            }
            throw new RuntimeException(ex);
        }
    }

    public static Integer processDeleteVersions(Context context, int itemId, String[] versionIDs) throws SQLException, AuthorizeException, IOException {
        try {
            VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
            VersionHistory versionHistory = versioningService.findVersionHistory(context, itemId);
            for (String id : versionIDs) {
                versioningService.removeVersion(context, Integer.parseInt(id));
            }
            context.commit();
            Version latestVersion = versionHistory.getLatestVersion();
            if (latestVersion == null) {
                return null;
            }
            return latestVersion.getItemID();
        }
        catch (Exception ex) {
            if (context != null && context.isValid()) {
                context.abort();
            }
            throw new RuntimeException(ex);
        }
    }

    public static boolean isLatest(Context context, Item item) {
        VersionHistory history = VersionUtil.retrieveVersionHistory((Context)context, (Item)item);
        return history == null || history.getLatestVersion().getItem().getID() == item.getID();
    }

    public static boolean hasVersionHistory(Context context, Item item) {
        VersionHistory history = VersionUtil.retrieveVersionHistory((Context)context, (Item)item);
        return history != null;
    }

    public static Version checkLatestVersion(Context context, Item item) throws SQLException {
        VersionHistory history = VersionUtil.retrieveVersionHistory((Context)context, (Item)item);
        if (history != null) {
            List allVersions = history.getVersions();
            for (Version version : allVersions) {
                if (!version.getItem().isArchived() && !AuthorizeManager.isAdmin((Context)context, (DSpaceObject)item.getOwningCollection())) continue;
                return version;
            }
        }
        return null;
    }

    public static VersionHistory retrieveVersionHistory(Context context, Item item) {
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        return versioningService.findVersionHistory(context, item.getID());
    }

    public static boolean isItemInSubmission(Context context, Item item) throws SQLException {
        WorkspaceItem workspaceItem = WorkspaceItem.findByItem((Context)context, (Item)item);
        WorkflowItem workflowItem = WorkflowItem.findByItem((Context)context, (Item)item);
        return workspaceItem != null || workflowItem != null;
    }

    public static String[] addItemIdentifier(Item item, Version version) {
        String[] result = null;
        String itemHandle = version.getItem().getHandle();
        DCValue[] identifiers = version.getItem().getMetadata("dc", "identifier", null, "*");
        String itemIdentifier = null;
        if (identifiers != null && identifiers.length > 0) {
            itemIdentifier = identifiers[0].value;
        }
        result = itemIdentifier != null ? new String[]{"/resource/" + itemIdentifier, itemIdentifier} : new String[]{"/handle/" + itemHandle, itemHandle};
        return result;
    }

    public static String getSummary(Context context, String stringVersionID) {
        String result = "";
        try {
            Integer versionID = Integer.parseInt(stringVersionID);
            VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
            Version version = versioningService.getVersion(context, versionID.intValue());
            if (version != null) {
                result = version.getSummary();
            }
        }
        catch (Exception ex) {
            if (context != null && context.isValid()) {
                context.abort();
            }
            throw new RuntimeException(ex);
        }
        return result;
    }
}

