/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.util;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.app.webui.util.AKeyBasedStyleSelection;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;

public class CollectionStyleSelection
extends AKeyBasedStyleSelection {
    private static Map<String, String> styles;
    private static Logger log;

    public String getStyleForItem(Item item) throws SQLException {
        Collection c = item.getOwningCollection();
        if (c != null) {
            return this.getFromMap(c.getHandle());
        }
        return "default";
    }

    private void readKeyStyleConfig() {
        styles = new HashMap();
        Enumeration e = ConfigurationManager.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("webui.itemdisplay.") || !key.endsWith(".collections")) continue;
            String styleName = key.substring("webui.itemdisplay.".length(), key.length() - ".collections".length());
            String[] collections = ConfigurationManager.getProperty((String)key).split(",");
            for (int i = 0; i < collections.length; ++i) {
                styles.put(collections[i].trim(), styleName.toLowerCase());
            }
        }
    }

    public String getFromMap(String handle) {
        String styleName;
        if (styles == null) {
            this.readKeyStyleConfig();
        }
        if ((styleName = (String)styles.get(handle)) == null) {
            return "default";
        }
        if (this.isConfigurationDefinedForStyle(styleName)) {
            log.warn((Object)("dspace.cfg specifies undefined item display style '" + styleName + "' for collection handle " + handle + ".  Using default"));
            return "default";
        }
        return styleName;
    }

    static {
        log = Logger.getLogger(CollectionStyleSelection.class);
    }
}

