/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.webui.submit.JSPStep;
import org.dspace.app.webui.submit.JSPStepManager;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.Context;
import org.dspace.submit.lookup.SubmissionLookupService;
import org.dspace.utils.DSpace;

public class JSPStartSubmissionLookupStep
extends JSPStep {
    private static final String START_LOOKUP_JSP = "/submit/start-lookup-submission.jsp";
    private static Logger log = Logger.getLogger(JSPStartSubmissionLookupStep.class);
    SubmissionLookupService slService = (SubmissionLookupService)new DSpace().getServiceManager().getServiceByName(SubmissionLookupService.class.getCanonicalName(), SubmissionLookupService.class);

    public void doPreProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        if (request.getAttribute("no.collection") == null || !((Boolean)request.getAttribute("no.collection")).booleanValue()) {
            request.setAttribute("s_uuid", (Object)UUID.randomUUID().toString());
        }
        int collectionID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"collectionid");
        Collection col = null;
        if (collectionID != -1) {
            col = Collection.find((Context)context, (int)collectionID);
        }
        if (col != null) {
            log.debug((Object)("Select Collection page skipped, since a Collection ID was already found.  Collection ID=" + collectionID));
        } else {
            Community com = UIUtil.getCommunityLocation((HttpServletRequest)request);
            Collection[] collections = com != null ? Collection.findAuthorized((Context)context, (Community)com, (int)3) : Collection.findAuthorized((Context)context, null, (int)3);
            request.setAttribute("collections", (Object)collections);
            request.setAttribute("collectionID", (Object)collectionID);
            Map identifiers2providers = this.slService.getProvidersIdentifiersMap();
            List searchProviders = this.slService.getSearchProviders();
            List fileProviders = this.slService.getFileProviders();
            request.setAttribute("identifiers2providers", (Object)identifiers2providers);
            request.setAttribute("searchProviders", (Object)searchProviders);
            request.setAttribute("fileLoaders", (Object)fileProviders);
            request.setAttribute("identifiers", (Object)this.slService.getIdentifiers());
            JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)START_LOOKUP_JSP);
        }
    }

    public void doPostProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, int status) throws ServletException, IOException, SQLException, AuthorizeException {
        if (status == 1) {
            request.setAttribute("no.collection", (Object)new Boolean(true));
            this.doPreProcessing(context, request, response, subInfo);
        } else if (status == 2) {
            JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)request.getParameter("collectionid"), (int)3);
        } else if (status == 3) {
            request.setAttribute("no.suuid", (Object)new Boolean(true));
            this.doPreProcessing(context, request, response, subInfo);
        } else if (status == 4) {
            request.setAttribute("expired", (Object)new Boolean(true));
            this.doPreProcessing(context, request, response, subInfo);
        } else if (status != 0) {
            request.setAttribute("no.suuid", (Object)new Boolean(true));
            this.doPreProcessing(context, request, response, subInfo);
        }
    }

    public String getReviewJSP(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) {
        return "";
    }
}

