/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.Group;

public class StatisticsServlet
extends DSpaceServlet {
    protected void doDSGet(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSPost(c, request, response);
    }

    protected void doDSPost(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        boolean publicise = ConfigurationManager.getBooleanProperty((String)"report.public");
        String navbar = !publicise ? "admin" : "default";
        request.setAttribute("navbar", (Object)navbar);
        boolean admin = Group.isMember((Context)c, (int)1);
        if (!publicise && !admin) {
            throw new AuthorizeException();
        }
        this.showStatistics(c, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showStatistics(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        StringBuffer report;
        block39: {
            report = new StringBuffer();
            String date = request.getParameter("date");
            request.setAttribute("date", (Object)date);
            request.setAttribute("general", (Object)Boolean.FALSE);
            File reportDir = new File(ConfigurationManager.getProperty((String)"report.dir"));
            File[] reports = reportDir.listFiles();
            File reportFile = null;
            FileInputStream fir = null;
            InputStreamReader ir = null;
            BufferedReader br = null;
            try {
                SimpleDateFormat sdf;
                ArrayList<Date> monthsList = new ArrayList<Date>();
                Pattern monthly = Pattern.compile("report-([0-9][0-9][0-9][0-9]-[0-9]+)\\.html");
                Pattern general = Pattern.compile("report-general-([0-9]+-[0-9]+-[0-9]+)\\.html");
                if (date == null) {
                    request.setAttribute("general", (Object)Boolean.TRUE);
                    sdf = new SimpleDateFormat("yyyy'-'M'-'dd");
                    Date mostRecentDate = null;
                    for (int i = 0; i < reports.length; ++i) {
                        Matcher matchGeneral = general.matcher(reports[i].getName());
                        if (!matchGeneral.matches()) continue;
                        Date parsedDate = null;
                        try {
                            parsedDate = sdf.parse(matchGeneral.group(1).trim());
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                        if (mostRecentDate == null) {
                            mostRecentDate = parsedDate;
                            reportFile = reports[i];
                        }
                        if (parsedDate == null || parsedDate.compareTo(mostRecentDate) <= 0) continue;
                        mostRecentDate = parsedDate;
                        reportFile = reports[i];
                    }
                }
                if (date != null) {
                    String desiredReport = "report-" + date + ".html";
                    for (int i = 0; i < reports.length; ++i) {
                        if (!reports[i].getName().equals(desiredReport)) continue;
                        reportFile = reports[i];
                    }
                }
                if (reportFile == null) {
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"statistics/no-report.jsp");
                    return;
                }
                sdf = new SimpleDateFormat("yyyy'-'M");
                for (int i = 0; i < reports.length; ++i) {
                    Matcher matchReport = monthly.matcher(reports[i].getName());
                    if (!matchReport.matches()) continue;
                    Date parsedDate = null;
                    try {
                        parsedDate = sdf.parse(matchReport.group(1).trim());
                    }
                    catch (ParseException e) {
                        // empty catch block
                    }
                    monthsList.add(parsedDate);
                }
                Object[] months = new Date[monthsList.size()];
                months = monthsList.toArray(months);
                Arrays.sort(months);
                request.setAttribute("months", (Object)months);
                if (reportFile == null) break block39;
                try {
                    fir = new FileInputStream(reportFile.getPath());
                    ir = new InputStreamReader((InputStream)fir, "UTF-8");
                    br = new BufferedReader(ir);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
                String line = null;
                while ((line = br.readLine()) != null) {
                    report.append(line);
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ioe) {}
                }
                if (ir != null) {
                    try {
                        ir.close();
                    }
                    catch (IOException ioe) {}
                }
                if (fir != null) {
                    try {
                        fir.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        request.setAttribute("report", (Object)report.toString());
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"statistics/report.jsp");
    }
}

