/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Utils;

public class SitemapServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(SitemapServlet.class);
    private boolean forSitemapsOrg;

    public void init() {
        this.forSitemapsOrg = false;
        String initParam = this.getInitParameter("type");
        if (initParam != null && initParam.equalsIgnoreCase("sitemaps.org")) {
            this.forSitemapsOrg = true;
        } else if (initParam == null || !initParam.equalsIgnoreCase("html")) {
            log.warn((Object)("Invalid initialization parameter for servlet " + this.getServletName() + ": assuming basic HTML"));
        }
    }

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String param = request.getParameter("map");
        String ext = this.forSitemapsOrg ? ".xml.gz" : ".html";
        String mimeType = this.forSitemapsOrg ? "text/xml" : "text/html";
        String fileStem = param == null ? "sitemap_index" : "sitemap" + param;
        this.sendFile(request, response, fileStem + ext, mimeType, this.forSitemapsOrg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(HttpServletRequest request, HttpServletResponse response, String file, String mimeType, boolean compressed) throws ServletException, IOException {
        File f = new File(ConfigurationManager.getProperty((String)"sitemap.dir"), file);
        if (!f.exists()) {
            response.setStatus(404);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/error/404.jsp");
            return;
        }
        long lastMod = f.lastModified();
        response.setDateHeader("Last-Modified", lastMod);
        long modSince = request.getDateHeader("If-Modified-Since");
        if (modSince != -1L && lastMod < modSince) {
            response.setStatus(304);
            return;
        }
        if (compressed) {
            response.setHeader("Content-Encoding", "gzip");
        }
        FileInputStream is = new FileInputStream(f);
        try {
            response.setContentType(mimeType);
            response.setHeader("Content-Length", String.valueOf(f.length()));
            Utils.bufferedCopy((InputStream)is, (OutputStream)response.getOutputStream());
        }
        finally {
            ((InputStream)is).close();
        }
        response.getOutputStream().flush();
    }
}

