/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.Utils;
import org.dspace.handle.HandleManager;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;
import org.dspace.utils.DSpace;

/*
 * Exception performing whole class analysis ignored.
 */
public class HTMLServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(HTMLServlet.class);
    private int maxDepthGuess = ConfigurationManager.getProperty((String)"webui.html.max-depth-guess") != null ? ConfigurationManager.getIntProperty((String)"webui.html.max-depth-guess") : 3;

    private static Bitstream getItemBitstreamByName(Item item, String bsName) throws SQLException {
        Bundle[] bundles = item.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Bitstream[] bitstreams = bundles[i].getBitstreams();
            for (int k = 0; k < bitstreams.length; ++k) {
                if (!bsName.equals(bitstreams[k].getName())) continue;
                return bitstreams[k];
            }
        }
        return null;
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSGet(context, request, response);
    }

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        Item item = null;
        Bitstream bitstream = null;
        String idString = request.getPathInfo();
        String filenameNoPath = null;
        String fullpath = null;
        String handle = null;
        if (idString != null) {
            int slashIndex;
            if (idString.startsWith("/")) {
                idString = idString.substring(1);
            }
            if ((slashIndex = idString.indexOf(47)) != -1 && (slashIndex = idString.indexOf(47, slashIndex + 1)) != -1) {
                String[] pathComponents;
                handle = idString.substring(0, slashIndex);
                fullpath = URLDecoder.decode(idString.substring(slashIndex + 1), "UTF-8");
                if ((slashIndex = fullpath.indexOf(47)) != -1 && (pathComponents = fullpath.split("/")).length <= this.maxDepthGuess + 1) {
                    filenameNoPath = pathComponents[pathComponents.length - 1];
                }
            }
        }
        if (handle != null && fullpath != null) {
            try {
                if (handle.startsWith("db-id")) {
                    String dbIDString = handle.substring(handle.indexOf(47) + 1);
                    int dbID = Integer.parseInt(dbIDString);
                    item = Item.find((Context)context, (int)dbID);
                } else {
                    item = (Item)HandleManager.resolveToObject((Context)context, (String)handle);
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (item != null && (bitstream = HTMLServlet.getItemBitstreamByName(item, fullpath)) == null && filenameNoPath != null) {
            bitstream = HTMLServlet.getItemBitstreamByName((Item)item, filenameNoPath);
        }
        if (bitstream != null) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"view_html", (String)("handle=" + handle + ",bitstream_id=" + bitstream.getID())));
            new DSpace().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, request, context, (DSpaceObject)bitstream));
            response.setContentType(bitstream.getFormat().getMIMEType());
            response.setHeader("Content-Length", String.valueOf(bitstream.getSize()));
            InputStream is = bitstream.retrieve();
            Utils.bufferedCopy((InputStream)is, (OutputStream)response.getOutputStream());
            is.close();
            response.getOutputStream().flush();
        } else {
            log.info((Object)LogManager.getHeader((Context)context, (String)"view_html", (String)("invalid_bitstream_id=" + idString)));
            JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)idString, (int)0);
        }
    }
}

