/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import com.sun.syndication.io.FeedException;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.SyndicationFeed;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.servlet.FeedServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.browse.BrowseEngine;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseInfo;
import org.dspace.browse.BrowserScope;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.Group;
import org.dspace.handle.HandleManager;
import org.dspace.search.Harvest;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;

/*
 * Exception performing whole class analysis ignored.
 */
public class FeedServlet
extends DSpaceServlet {
    public static final String SITE_FEED_KEY = "site";
    private static final long HOUR_MSECS = 3600000L;
    private static Logger log = Logger.getLogger(FeedServlet.class);
    private String clazz = "org.dspace.app.webui.servlet.FeedServlet";
    private static boolean enabled = false;
    private static int itemCount = 0;
    private static Map<String, CacheFeed> feedCache = null;
    private static int cacheSize = 0;
    private static int cacheAge = 0;
    private static List<String> formats = null;
    private static boolean includeAll = true;

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        CacheFeed cFeed;
        int split;
        includeAll = ConfigurationManager.getBooleanProperty((String)"harvest.includerestricted.rss", (boolean)true);
        String path = request.getPathInfo();
        String feedType = null;
        String handle = null;
        Locale locale = request.getLocale();
        ResourceBundle msgs = ResourceBundle.getBundle("Messages", locale);
        HashMap<String, String> labelMap = new HashMap<String, String>();
        labelMap.put("notitle", msgs.getString(this.clazz + ".notitle"));
        labelMap.put("logo.title", msgs.getString(this.clazz + ".logo.title"));
        labelMap.put("general-feed.description", msgs.getString(this.clazz + ".general-feed.description"));
        labelMap.put("ui.type", "jspui");
        for (String selector : SyndicationFeed.getDescriptionSelectors()) {
            labelMap.put("metadata." + selector, msgs.getString("metadata." + selector));
        }
        if (path != null && (split = (path = path.substring(1)).indexOf(47)) != -1) {
            feedType = path.substring(0, split);
            handle = path.substring(split + 1);
        }
        DSpaceObject dso = null;
        if (handle != null && !handle.equals("site") && (dso = HandleManager.resolveToObject((Context)context, (String)handle)) == null) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"invalid_handle", (String)("path=" + path)));
            JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)handle, (int)-1);
            return;
        }
        if (!enabled || dso != null && dso.getType() != 3 && dso.getType() != 4) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"invalid_id", (String)("path=" + path)));
            JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)path, (int)-1);
            return;
        }
        if (feedType == null || !formats.contains(feedType)) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"invalid_syndformat", (String)("path=" + path)));
            JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)path, (int)-1);
            return;
        }
        if (dso != null && dso.getType() == 3) {
            labelMap.put("feed.title", MessageFormat.format(msgs.getString(this.clazz + ".feed.title"), msgs.getString(this.clazz + ".feed-type.collection"), ((Collection)dso).getMetadata("short_description")));
        } else if (dso != null && dso.getType() == 4) {
            labelMap.put("feed.title", MessageFormat.format(msgs.getString(this.clazz + ".feed.title"), msgs.getString(this.clazz + ".feed-type.community"), ((Community)dso).getMetadata("short_description")));
        }
        String cacheKey = (handle == null ? "site" : handle) + "." + locale.toString();
        SyndicationFeed feed = null;
        if (feedCache != null && (cFeed = (CacheFeed)feedCache.get(cacheKey)) != null) {
            boolean cacheFeedCurrent = false;
            if (cFeed.timeStamp + (long)cacheAge * 3600000L < System.currentTimeMillis()) {
                cacheFeedCurrent = true;
            } else if (!this.itemsChanged(context, dso, cFeed.timeStamp)) {
                cFeed.timeStamp = System.currentTimeMillis();
                cacheFeedCurrent = true;
            }
            if (cacheFeedCurrent) {
                feed = cFeed.access();
            }
        }
        if (feed == null) {
            feed = new SyndicationFeed("jspui");
            feed.populate(request, dso, (DSpaceObject[])this.getItems(context, dso), labelMap);
            if (feedCache != null) {
                FeedServlet.cache((String)cacheKey, (CacheFeed)new CacheFeed(feed));
            }
        }
        try {
            feed.setType(feedType);
            response.setContentType("text/xml; charset=UTF-8");
            feed.output((Writer)response.getWriter());
        }
        catch (FeedException fex) {
            throw new IOException(fex.getMessage(), fex);
        }
    }

    private boolean itemsChanged(Context context, DSpaceObject dso, long timeStamp) throws SQLException {
        DCDate dcStartDate = new DCDate(new Date(timeStamp));
        DCDate dcEndDate = new DCDate(new Date(System.currentTimeMillis()));
        String startDate = dcStartDate.toString().substring(0, 10);
        String endDate = dcEndDate.toString().substring(0, 10);
        try {
            return Harvest.harvest((Context)context, (DSpaceObject)dso, (String)startDate, (String)endDate, (int)0, (int)1, (!includeAll ? 1 : 0) != 0, (boolean)false, (boolean)false, (boolean)includeAll).size() > 0;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    private Item[] getItems(Context context, DSpaceObject dso) throws IOException, SQLException {
        try {
            String idx = ConfigurationManager.getProperty((String)"recent.submissions.sort-option");
            if (idx == null) {
                throw new IOException("There is no configuration supplied for: recent.submissions.sort-option");
            }
            BrowseIndex bix = BrowseIndex.getItemBrowseIndex();
            if (bix == null) {
                throw new IOException("There is no browse index with the name: " + idx);
            }
            BrowserScope scope = new BrowserScope(context);
            scope.setBrowseIndex(bix);
            if (dso != null) {
                scope.setBrowseContainer(dso);
            }
            for (SortOption so : SortOption.getSortOptions()) {
                if (!so.getName().equals(idx)) continue;
                scope.setSortBy(so.getNumber());
            }
            scope.setOrder("DESC");
            scope.setResultsPerPage(itemCount);
            BrowseEngine be = new BrowseEngine(context);
            BrowseInfo bi = be.browseMini(scope);
            Item[] results = bi.getItemResults(context);
            if (includeAll) {
                return results;
            }
            ArrayList<Item> items = new ArrayList<Item>();
            block4: for (Item result : results) {
                for (Group group : AuthorizeManager.getAuthorizedGroups((Context)context, (DSpaceObject)result, (int)0)) {
                    if (group.getID() != 0) continue;
                    items.add(result);
                    continue block4;
                }
            }
            return items.toArray(new Item[items.size()]);
        }
        catch (SortException se) {
            log.error((Object)"caught exception: ", (Throwable)se);
            throw new IOException(se.getMessage(), se);
        }
        catch (BrowseException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new IOException(e.getMessage(), e);
        }
    }

    private static void cache(String feedKey, CacheFeed newFeed) {
        if (feedCache.size() >= cacheSize) {
            int total = 0;
            String minKey = null;
            CacheFeed minFeed = null;
            CacheFeed maxFeed = null;
            for (String key : feedCache.keySet()) {
                CacheFeed feed = (CacheFeed)feedCache.get(key);
                if (minKey != null) {
                    if (feed.hits < minFeed.hits) {
                        minKey = key;
                        minFeed = feed;
                    }
                    if (feed.hits >= maxFeed.hits) {
                        maxFeed = feed;
                    }
                } else {
                    minKey = key;
                    minFeed = feed;
                    maxFeed = feed;
                }
                total += feed.hits;
            }
            int avg = total / feedCache.size();
            String logMsg = "feedCache() - size: " + feedCache.size() + " Hits - total: " + total + " avg: " + avg + " max: " + maxFeed.hits + " min: " + minFeed.hits;
            log.info((Object)logMsg);
            feedCache.remove(minKey);
        }
        feedCache.put(feedKey, newFeed);
    }

    static {
        enabled = ConfigurationManager.getBooleanProperty((String)"webui.feed.enable");
        if (enabled) {
            String fmtsStr = ConfigurationManager.getProperty((String)"webui.feed.formats");
            if (fmtsStr != null) {
                formats = new ArrayList();
                String[] fmts = fmtsStr.split(",");
                for (int i = 0; i < fmts.length; ++i) {
                    formats.add(fmts[i]);
                }
            }
            itemCount = ConfigurationManager.getIntProperty((String)"webui.feed.items");
            cacheSize = ConfigurationManager.getIntProperty((String)"webui.feed.cache.size");
            if (cacheSize > 0) {
                feedCache = new HashMap();
                cacheAge = ConfigurationManager.getIntProperty((String)"webui.feed.cache.age");
            }
        }
    }
}

