/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.util.Authenticate;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class DSpaceServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(DSpaceServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Context context = null;
        request.setCharacterEncoding("UTF-8");
        UIUtil.storeOriginalURL((HttpServletRequest)request);
        try {
            context = UIUtil.obtainContext((HttpServletRequest)request);
            request = Authenticate.getRealRequest((HttpServletRequest)request);
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"http_request", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
            }
            if (request.getMethod().equals("POST")) {
                this.doDSPost(context, request, response);
            } else {
                this.doDSGet(context, request, response);
            }
        }
        catch (SQLException se) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"database_error", (String)se.toString()), (Throwable)se);
            UIUtil.sendAlert((HttpServletRequest)request, (Exception)se);
            JSPManager.showInternalError((HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (AuthorizeException ae) {
            if (context.getCurrentUser() != null || Authenticate.startAuthentication((Context)context, (HttpServletRequest)request, (HttpServletResponse)response)) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"authorize_error", (String)ae.toString()));
                JSPManager.showAuthorizeError((HttpServletRequest)request, (HttpServletResponse)response, (AuthorizeException)ae);
            }
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
    }

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        super.doGet(request, response);
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        super.doGet(request, response);
    }
}

