/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.jsptag;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.ArrayUtils;
import org.dspace.content.Community;

public class CommunityListTag
extends TagSupport {
    private transient Community[] communities;
    private static final long serialVersionUID = 5788338729470292501L;

    public int doStartTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            out.println("<table align=\"center\" class=\"table\" title=\"Community List\">");
            out.print("<tr><th id=\"t5\" class=\"oddRowOddCol\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.CommunityListTag.communityName") + "</th></tr>");
            String row = "even";
            for (int i = 0; i < this.communities.length; ++i) {
                String name = this.communities[i].getMetadata("name");
                out.print("<tr><td headers=\"t5\" class=\"" + row + "RowEvenCol\">");
                out.print("<a href=\"");
                HttpServletRequest hrq = (HttpServletRequest)this.pageContext.getRequest();
                out.print(hrq.getContextPath() + "/handle/");
                out.print(this.communities[i].getHandle());
                out.print("\">");
                out.print(name);
                out.print("</a>");
                out.println("</td></tr>");
                row = row.equals("odd") ? "even" : "odd";
            }
            out.println("</table>");
        }
        catch (IOException ie) {
            throw new JspException((Throwable)ie);
        }
        return 0;
    }

    public Community[] getCommunities() {
        return (Community[])ArrayUtils.clone((Object[])this.communities);
    }

    public void setCommunities(Community[] communitiesIn) {
        this.communities = (Community[])ArrayUtils.clone((Object[])communitiesIn);
    }

    public void release() {
        this.communities = null;
    }
}

