/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.discovery;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.app.bulkedit.MetadataExport;
import org.dspace.app.util.OpenSearch;
import org.dspace.app.util.SyndicationFeed;
import org.dspace.app.webui.discovery.DiscoverUtility;
import org.dspace.app.webui.search.SearchProcessorException;
import org.dspace.app.webui.search.SearchRequestProcessor;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilter;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;
import org.w3c.dom.Document;

public class DiscoverySearchRequestProcessor
implements SearchRequestProcessor {
    private static final int ITEMMAP_RESULT_PAGE_SIZE = 50;
    private static String msgKey = "org.dspace.app.webui.servlet.FeedServlet";
    private static Logger log = Logger.getLogger(DiscoverySearchRequestProcessor.class);
    private Map<String, Map<String, String>> localeLabels = null;
    private List<String> searchIndices = null;

    public synchronized void init() {
        if (this.localeLabels == null) {
            this.localeLabels = new HashMap();
        }
        if (this.searchIndices == null) {
            this.searchIndices = new ArrayList();
            DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration();
            this.searchIndices.add("any");
            for (DiscoverySearchFilter sFilter : discoveryConfiguration.getSearchFilters()) {
                this.searchIndices.add(sFilter.getIndexFieldName());
            }
        }
    }

    public void doOpenSearch(Context context, HttpServletRequest request, HttpServletResponse response) throws SearchProcessorException, IOException, ServletException {
        DSpaceObject container;
        String path;
        this.init();
        String scope = request.getParameter("scope");
        if (scope != null && "".equals(scope)) {
            scope = null;
        }
        if ((path = request.getPathInfo()) != null && path.endsWith("description.xml")) {
            String svcDescrip = OpenSearch.getDescription((String)scope);
            response.setContentType(OpenSearch.getContentType((String)"opensearchdescription"));
            response.setContentLength(svcDescrip.length());
            response.getWriter().write(svcDescrip);
            return;
        }
        String format = request.getParameter("format");
        if (format == null || "".equals(format)) {
            format = "atom";
        }
        if (!OpenSearch.getFormats().contains(format)) {
            response.sendError(400);
            return;
        }
        try {
            container = DiscoverUtility.getSearchScope((Context)context, (HttpServletRequest)request);
        }
        catch (Exception e) {
            throw new SearchProcessorException(e.getMessage(), (Throwable)e);
        }
        DiscoverQuery queryArgs = DiscoverUtility.getDiscoverQuery((Context)context, (HttpServletRequest)request, (DSpaceObject)container, (boolean)false);
        String query = queryArgs.getQuery();
        DiscoverResult qResults = null;
        try {
            qResults = SearchUtils.getSearchService().search(context, container, queryArgs);
        }
        catch (SearchServiceException e) {
            log.error((Object)LogManager.getHeader((Context)context, (String)"opensearch", (String)("query=" + queryArgs.getQuery() + ",scope=" + scope + ",error=" + e.getMessage())), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        log.info((Object)LogManager.getHeader((Context)context, (String)"opensearch", (String)("scope=" + scope + ",query=\"" + query + "\",results=(" + qResults.getTotalSearchResults() + ")")));
        Map labelMap = this.getLabels(request);
        DSpaceObject[] dsoResults = new DSpaceObject[qResults.getDspaceObjects().size()];
        qResults.getDspaceObjects().toArray(dsoResults);
        Document resultsDoc = OpenSearch.getResultsDoc((String)format, (String)query, (int)((int)qResults.getTotalSearchResults()), (int)qResults.getStart(), (int)qResults.getMaxResults(), (DSpaceObject)container, (DSpaceObject[])dsoResults, (Map)labelMap);
        try {
            Transformer xf = TransformerFactory.newInstance().newTransformer();
            response.setContentType(OpenSearch.getContentType((String)format));
            xf.transform(new DOMSource(resultsDoc), new StreamResult(response.getWriter()));
        }
        catch (TransformerException e) {
            log.error((Object)e);
            throw new ServletException(e.toString());
        }
    }

    private Map<String, String> getLabels(HttpServletRequest request) {
        Locale locale = UIUtil.getSessionLocale((HttpServletRequest)request);
        Map labelMap = (Map)this.localeLabels.get(locale.toString());
        if (labelMap == null) {
            labelMap = this.getLocaleLabels(locale);
            this.localeLabels.put(locale.toString(), labelMap);
        }
        return labelMap;
    }

    private Map<String, String> getLocaleLabels(Locale locale) {
        HashMap<String, String> labelMap = new HashMap<String, String>();
        labelMap.put("notitle", I18nUtil.getMessage((String)(msgKey + ".notitle"), (Locale)locale));
        labelMap.put("logo.title", I18nUtil.getMessage((String)(msgKey + ".logo.title"), (Locale)locale));
        labelMap.put("general-feed.description", I18nUtil.getMessage((String)(msgKey + ".general-feed.description"), (Locale)locale));
        labelMap.put("ui.type", "jspui");
        for (String selector : SyndicationFeed.getDescriptionSelectors()) {
            labelMap.put("metadata." + selector, I18nUtil.getMessage((String)("metadata." + selector), (Locale)locale));
        }
        return labelMap;
    }

    /*
     * Unable to fully structure code
     */
    public void doSimpleSearch(Context context, HttpServletRequest request, HttpServletResponse response) throws SearchProcessorException, IOException, ServletException {
        try {
            scope = DiscoverUtility.getSearchScope((Context)context, (HttpServletRequest)request);
        }
        catch (IllegalStateException e) {
            throw new SearchProcessorException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new SearchProcessorException(e.getMessage(), (Throwable)e);
        }
        discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)scope);
        sortFields = discoveryConfiguration.getSearchSortConfiguration().getSortFields();
        sortOptions = new ArrayList<String>();
        for (DiscoverySortFieldConfiguration sortFieldConfiguration : sortFields) {
            sortField = SearchUtils.getSearchService().toSortFieldIndex(sortFieldConfiguration.getMetadataField(), sortFieldConfiguration.getType());
            sortOptions.add(sortField);
        }
        request.setAttribute("sortOptions", sortOptions);
        queryArgs = DiscoverUtility.getDiscoverQuery((Context)context, (HttpServletRequest)request, (DSpaceObject)scope, (boolean)true);
        queryArgs.setSpellCheck(discoveryConfiguration.isSpellCheckEnabled());
        availableFacet = discoveryConfiguration.getSidebarFacets();
        request.setAttribute("facetsConfig", (Object)(availableFacet != null ? availableFacet : new ArrayList<E>()));
        etal = UIUtil.getIntParameter((HttpServletRequest)request, (String)"etal");
        if (etal == -1) {
            etal = ConfigurationManager.getIntProperty((String)"webui.itemlist.author-limit");
        }
        request.setAttribute("etal", (Object)etal);
        query = queryArgs.getQuery();
        request.setAttribute("query", (Object)query);
        request.setAttribute("queryArgs", (Object)queryArgs);
        availableFilters = discoveryConfiguration.getSearchFilters();
        request.setAttribute("availableFilters", (Object)availableFilters);
        appliedFilters = DiscoverUtility.getFilters((HttpServletRequest)request);
        request.setAttribute("appliedFilters", (Object)appliedFilters);
        appliedFilterQueries = new ArrayList<String>();
        for (String[] filter : appliedFilters) {
            appliedFilterQueries.add(filter[0] + "::" + filter[1] + "::" + filter[2]);
        }
        request.setAttribute("appliedFilterQueries", appliedFilterQueries);
        scopes = new ArrayList<Object>();
        if (scope == null) {
            try {
                topCommunities = Community.findAllTop((Context)context);
            }
            catch (SQLException e) {
                throw new SearchProcessorException(e.getMessage(), (Throwable)e);
            }
            for (Community com : topCommunities) {
                scopes.add(com);
            }
        } else {
            try {
                for (pDso = scope.getParentObject(); pDso != null; pDso = pDso.getParentObject()) {
                    scopes.add(0, pDso);
                }
                scopes.add(scope);
                if (!(scope instanceof Community)) ** GOTO lbl68
                for (Community com : comms = ((Community)scope).getSubcommunities()) {
                    scopes.add(com);
                }
                for (Collection col : colls = ((Community)scope).getCollections()) {
                    scopes.add(col);
                }
            }
            catch (SQLException e) {
                throw new SearchProcessorException(e.getMessage(), (Throwable)e);
            }
        }
lbl68:
        // 3 sources

        request.setAttribute("scope", (Object)scope);
        request.setAttribute("scopes", scopes);
        qResults = null;
        try {
            qResults = SearchUtils.getSearchService().search(context, scope, queryArgs);
            resultsListComm = new ArrayList<Community>();
            resultsListColl = new ArrayList<Collection>();
            resultsListItem = new ArrayList<Item>();
            for (DSpaceObject dso : qResults.getDspaceObjects()) {
                if (dso instanceof Item) {
                    resultsListItem.add((Item)dso);
                    continue;
                }
                if (dso instanceof Collection) {
                    resultsListColl.add((Collection)dso);
                    continue;
                }
                if (!(dso instanceof Community)) continue;
                resultsListComm.add((Community)dso);
            }
            resultsCommunities = new Community[resultsListComm.size()];
            resultsCollections = new Collection[resultsListColl.size()];
            resultsItems = new Item[resultsListItem.size()];
            resultsCommunities = resultsListComm.toArray(resultsCommunities);
            resultsCollections = resultsListColl.toArray(resultsCollections);
            resultsItems = resultsListItem.toArray(resultsItems);
            DiscoverySearchRequestProcessor.log.info((Object)LogManager.getHeader((Context)context, (String)"search", (String)("scope=" + scope + ",query=\"" + query + "\",results=(" + resultsCommunities.length + "," + resultsCollections.length + "," + resultsItems.length + ")")));
            pageTotal = 1L + (qResults.getTotalSearchResults() - 1L) / (long)qResults.getMaxResults();
            pageCurrent = 1 + qResults.getStart() / qResults.getMaxResults();
            pageLast = pageCurrent + 3L > pageTotal ? pageTotal : pageCurrent + 3L;
            pageFirst = pageCurrent - 3L > 1L ? pageCurrent - 3L : 1L;
            request.setAttribute("items", (Object)resultsItems);
            request.setAttribute("communities", (Object)resultsCommunities);
            request.setAttribute("collections", (Object)resultsCollections);
            request.setAttribute("pagetotal", (Object)new Long(pageTotal));
            request.setAttribute("pagecurrent", (Object)new Long(pageCurrent));
            request.setAttribute("pagelast", (Object)new Long(pageLast));
            request.setAttribute("pagefirst", (Object)new Long(pageFirst));
            request.setAttribute("spellcheck", (Object)qResults.getSpellCheckQuery());
            request.setAttribute("queryresults", (Object)qResults);
            try {
                if (AuthorizeManager.isAdmin((Context)context)) {
                    request.setAttribute("admin_button", (Object)new Boolean(true));
                }
            }
            catch (SQLException e) {
                throw new SearchProcessorException(e.getMessage(), (Throwable)e);
            }
            if ("submit_export_metadata".equals(UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit"))) {
                this.exportMetadata(context, response, resultsItems);
            }
        }
        catch (SearchServiceException e) {
            DiscoverySearchRequestProcessor.log.error((Object)LogManager.getHeader((Context)context, (String)"search", (String)("query=" + queryArgs.getQuery() + ",scope=" + scope + ",error=" + e.getMessage())), (Throwable)e);
            request.setAttribute("search.error", (Object)true);
            request.setAttribute("search.error.message", (Object)e.getMessage());
        }
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/search/discovery.jsp");
    }

    protected void exportMetadata(Context context, HttpServletResponse response, Item[] items) throws IOException, ServletException {
        log.info((Object)LogManager.getHeader((Context)context, (String)"metadataexport", (String)"exporting_search"));
        ArrayList<Integer> iids = new ArrayList<Integer>();
        for (Item item : items) {
            iids.add(item.getID());
        }
        ItemIterator ii = new ItemIterator(context, iids);
        MetadataExport exporter = new MetadataExport(context, ii, false);
        DSpaceCSV csv = exporter.export();
        response.setContentType("text/csv; charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=search-results.csv");
        PrintWriter out = response.getWriter();
        out.write(csv.toString());
        out.flush();
        out.close();
        log.info((Object)LogManager.getHeader((Context)context, (String)"metadataexport", (String)"exported_file:search-results.csv"));
    }

    public void doAdvancedSearch(Context context, HttpServletRequest request, HttpServletResponse response) throws SearchProcessorException, IOException, ServletException {
        response.sendRedirect(request.getContextPath() + "/simple-search");
    }

    public void doItemMapSearch(Context context, HttpServletRequest request, HttpServletResponse response) throws SearchProcessorException, ServletException, IOException {
        String queryString = request.getParameter("query");
        Collection collection = (Collection)request.getAttribute("collection");
        int page = UIUtil.getIntParameter((HttpServletRequest)request, (String)"page") - 1;
        int offset = page > 0 ? page * 50 : 0;
        String idx = request.getParameter("index");
        if (StringUtils.isNotBlank((String)idx) && !idx.equalsIgnoreCase("any")) {
            queryString = idx + ":(" + queryString + ")";
        }
        DiscoverQuery query = new DiscoverQuery();
        query.setQuery(queryString);
        query.addFilterQueries(new String[]{"-location:l" + collection.getID()});
        query.setMaxResults(50);
        query.setStart(offset);
        DiscoverResult results = null;
        try {
            results = SearchUtils.getSearchService().search(context, query);
        }
        catch (SearchServiceException e) {
            throw new SearchProcessorException(e.getMessage(), (Throwable)e);
        }
        HashMap<Integer, Item> items = new HashMap<Integer, Item>();
        List resultDSOs = results.getDspaceObjects();
        for (DSpaceObject dso : resultDSOs) {
            if (dso == null || dso.getType() != 2) continue;
            Item item = (Item)dso;
            items.put(item.getID(), item);
        }
        request.setAttribute("browsetext", (Object)queryString);
        request.setAttribute("items", items);
        request.setAttribute("more", (Object)(results.getTotalSearchResults() > (long)(offset + 50) ? 1 : 0));
        request.setAttribute("browsetype", (Object)"Add");
        request.setAttribute("page", (Object)(page > 0 ? page + 1 : 1));
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"itemmap-browse.jsp");
    }

    public String getI18NKeyPrefix() {
        return "jsp.search.filter.";
    }

    public List<String> getSearchIndices() {
        this.init();
        return this.searchIndices;
    }
}

