/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.discovery;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.webui.discovery.DiscoverUtility;
import org.dspace.app.webui.json.JSONRequest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchUtils;

public class DiscoveryJSONRequest
extends JSONRequest {
    public void doJSONRequest(Context context, HttpServletRequest request, HttpServletResponse resp) throws AuthorizeException, IOException {
        String reqPath = request.getPathInfo();
        if (reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        if (reqPath.equalsIgnoreCase(this.getSubPath() + "/autocomplete")) {
            this.doAutocomplete(context, request, resp);
            return;
        }
        resp.sendError(404);
    }

    private void doAutocomplete(Context context, HttpServletRequest request, HttpServletResponse resp) {
        try {
            DSpaceObject scope = DiscoverUtility.getSearchScope((Context)context, (HttpServletRequest)request);
            DiscoverQuery autocompleteQuery = DiscoverUtility.getDiscoverAutocomplete((Context)context, (HttpServletRequest)request, (DSpaceObject)scope);
            DiscoverResult qResults = SearchUtils.getSearchService().search(context, autocompleteQuery);
            Set facets = qResults.getFacetResults().keySet();
            List fResults = new ArrayList();
            if (facets != null && facets.size() > 0) {
                String autocompleteField = (String)facets.toArray()[0];
                fResults = qResults.getFacetResult(autocompleteField);
            }
            Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new /* Unavailable Anonymous Inner Class!! */).create();
            JsonElement tree = gson.toJsonTree(fResults);
            JsonObject jo = new JsonObject();
            jo.add("autocomplete", tree);
            resp.getWriter().write(jo.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

