/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.authority.ChoiceAuthorityManager;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.ChoicesXMLGenerator;
import org.dspace.core.Context;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AuthorityChooseServlet
extends DSpaceServlet {
    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.process(context, request, response);
    }

    @Override
    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.process(context, request, response);
    }

    private void process(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String[] paths = request.getPathInfo().split("/");
        String field = paths[paths.length - 1];
        ChoiceAuthorityManager cam = ChoiceAuthorityManager.getManager();
        String query = request.getParameter("query");
        String format = request.getParameter("format");
        int collection = UIUtil.getIntParameter((HttpServletRequest)request, (String)"collection");
        int start = UIUtil.getIntParameter((HttpServletRequest)request, (String)"start");
        int limit = UIUtil.getIntParameter((HttpServletRequest)request, (String)"limit");
        Choices result = cam.getMatches(field, query, collection, start, limit, null);
        response.setContentType("text/xml; charset=\"utf-8\"");
        PrintWriter writer = response.getWriter();
        Properties props = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        Serializer ser = SerializerFactory.getSerializer((Properties)props);
        ser.setWriter((Writer)writer);
        try {
            ChoicesXMLGenerator.generate((Choices)result, (String)format, (ContentHandler)ser.asContentHandler());
        }
        catch (SAXException e) {
            throw new IOException(e.toString(), e);
        }
        finally {
            ser.reset();
        }
        ((Writer)writer).flush();
    }
}

