/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif.service;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.iiif.model.generator.CanvasGenerator;
import org.dspace.app.iiif.model.generator.CanvasItemsGenerator;
import org.dspace.app.iiif.service.AbstractResourceService;
import org.dspace.app.iiif.service.CanvasService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
@Component
public class SequenceService
extends AbstractResourceService {
    private static final Logger log = LogManager.getLogger(SequenceService.class);
    int counter = 0;
    @Autowired
    CanvasItemsGenerator sequenceGenerator;
    @Autowired
    CanvasService canvasService;

    public SequenceService(ConfigurationService configurationService) {
        this.setConfiguration(configurationService);
    }

    public CanvasItemsGenerator getSequence(Item item) {
        this.sequenceGenerator.setIdentifier(this.IIIF_ENDPOINT + item.getID() + "/sequence/s0");
        return this.sequenceGenerator;
    }

    public CanvasGenerator addCanvas(Context context, Item item, Bundle bnd, Bitstream bitstream) {
        String mimeType = this.utils.getBitstreamMimeType(bitstream, context);
        String manifestId = item.getID().toString();
        CanvasGenerator canvasGenerator = this.canvasService.getCanvas(context, manifestId, bitstream, bnd, item, this.counter, mimeType);
        this.sequenceGenerator.addCanvas(canvasGenerator);
        ++this.counter;
        return canvasGenerator;
    }
}

