/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif.service;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dspace.app.iiif.model.generator.CanvasGenerator;
import org.dspace.app.iiif.model.generator.RangeGenerator;
import org.dspace.app.iiif.service.AbstractResourceService;
import org.dspace.app.iiif.service.CanvasService;
import org.dspace.content.Bitstream;
import org.dspace.core.I18nUtil;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
@Component
public class RangeService
extends AbstractResourceService {
    @Autowired
    CanvasService canvasService;
    private Map<String, RangeGenerator> tocRanges = new LinkedHashMap<String, RangeGenerator>();
    private RangeGenerator currentRange;
    private RangeGenerator root;

    public RangeService(ConfigurationService configurationService) {
        this.setConfiguration(configurationService);
    }

    public RangeGenerator getRootRange() {
        return this.root;
    }

    public void setRootRange(String manifestId) {
        this.root = new RangeGenerator(this);
        this.root.addViewingHint("top");
        this.root.setLabel(I18nUtil.getMessage((String)"iiif.toc.root-label"));
        this.root.setIdentifier(manifestId + "/range/r0");
    }

    public Map<String, RangeGenerator> getTocRanges() {
        return this.tocRanges;
    }

    public void updateRanges(Bitstream bitstream, String bundleToCPrefix, CanvasGenerator canvas) {
        List<String> tocs = this.utils.getIIIFToCs(bitstream, bundleToCPrefix);
        if (tocs.size() > 0) {
            this.addTocRange(tocs, canvas);
        } else if (this.tocRanges.size() > 0) {
            String canvasIdentifier = canvas.getIdentifier();
            CanvasGenerator simpleCanvas = this.canvasService.getRangeCanvasReference(canvasIdentifier);
            this.currentRange.addCanvas(simpleCanvas);
        }
    }

    private void addTocRange(List<String> tocs, CanvasGenerator canvasGenerator) {
        for (String toc : tocs) {
            RangeGenerator tempRange = this.root;
            String[] parts = toc.split("\\|\\|\\|");
            Object key = "";
            for (int pIdx = 0; pIdx < parts.length; ++pIdx) {
                if (pIdx > 0) {
                    key = (String)key + "|||";
                }
                if (this.tocRanges.get(key = (String)key + parts[pIdx]) != null) {
                    tempRange = this.tocRanges.get(key);
                    continue;
                }
                RangeGenerator range = new RangeGenerator(this);
                range.setLabel(parts[pIdx]);
                tempRange.addSubRange(range);
                this.tocRanges.put((String)key, range);
                tempRange = range;
            }
            tempRange.addCanvas(this.canvasService.getRangeCanvasReference(canvasGenerator.getIdentifier()));
            this.currentRange = tempRange;
        }
    }

    public RangeGenerator getRangeReference(RangeGenerator range) {
        return new RangeGenerator(this).setIdentifier(range.getIdentifier());
    }
}

