/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif.model.generator;

import de.digitalcollections.iiif.model.ImageContent;
import de.digitalcollections.iiif.model.MetadataEntry;
import de.digitalcollections.iiif.model.OtherContent;
import de.digitalcollections.iiif.model.PropertyValue;
import de.digitalcollections.iiif.model.Service;
import de.digitalcollections.iiif.model.enums.ViewingHint;
import de.digitalcollections.iiif.model.search.ContentSearchService;
import de.digitalcollections.iiif.model.sharedcanvas.Manifest;
import de.digitalcollections.iiif.model.sharedcanvas.Range;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import de.digitalcollections.iiif.model.sharedcanvas.Sequence;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.dspace.app.iiif.model.generator.BehaviorGenerator;
import org.dspace.app.iiif.model.generator.CanvasItemsGenerator;
import org.dspace.app.iiif.model.generator.ContentSearchGenerator;
import org.dspace.app.iiif.model.generator.ExternalLinksGenerator;
import org.dspace.app.iiif.model.generator.IIIFResource;
import org.dspace.app.iiif.model.generator.ImageContentGenerator;
import org.dspace.app.iiif.model.generator.MetadataEntryGenerator;
import org.dspace.app.iiif.model.generator.PropertyValueGenerator;
import org.dspace.app.iiif.model.generator.RangeGenerator;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
@Component
public class ManifestGenerator
implements IIIFResource {
    private String identifier;
    private String label;
    private PropertyValue description;
    private ImageContent logo;
    private ViewingHint viewingHint;
    private Sequence sequence;
    private OtherContent seeAlso;
    private OtherContent related;
    private ImageContent thumbnail;
    private ContentSearchService searchService;
    private List<OtherContent> renderings = new ArrayList<OtherContent>();
    private final List<URI> license = new ArrayList<URI>();
    private final List<MetadataEntry> metadata = new ArrayList<MetadataEntry>();
    private final List<Range> ranges = new ArrayList<Range>();

    public void setIdentifier(@NotNull String identifier) {
        if (identifier.isEmpty()) {
            throw new RuntimeException("Invalid manifest identifier. Cannot be an empty string.");
        }
        this.identifier = identifier;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void addLogo(ImageContentGenerator logo) {
        this.logo = (ImageContent)logo.generateResource();
    }

    public void addViewingHint(String viewingHint) {
        BehaviorGenerator hint = new BehaviorGenerator().setType(viewingHint);
        this.viewingHint = hint.generateValue();
    }

    public void addSequence(CanvasItemsGenerator sequence) {
        this.sequence = (Sequence)sequence.generateResource();
    }

    public void addSeeAlso(ExternalLinksGenerator seeAlso) {
        this.seeAlso = (OtherContent)seeAlso.generateResource();
    }

    public void addThumbnail(ImageContentGenerator thumbnail) {
        this.thumbnail = (ImageContent)thumbnail.generateResource();
    }

    public void addRelated(ExternalLinksGenerator related) {
        this.related = (OtherContent)related.generateResource();
    }

    public void addService(ContentSearchGenerator searchService) {
        this.searchService = (ContentSearchService)searchService.generateService();
    }

    public void addMetadata(String field, String value, String ... rest) {
        MetadataEntryGenerator meg = new MetadataEntryGenerator().setField(field).setValue(value, rest);
        this.metadata.add(meg.generateValue());
    }

    public void addLicense(String license) {
        this.license.add(URI.create(license));
    }

    public void addDescription(String value) {
        this.description = new PropertyValueGenerator().getPropertyValue(value).generateValue();
    }

    public void addRange(RangeGenerator rangeGenerator) {
        this.ranges.add((Range)rangeGenerator.generateResource());
    }

    public void addRendering(ExternalLinksGenerator otherContent) {
        this.renderings.add((OtherContent)otherContent.generateResource());
    }

    public Resource<Manifest> generateResource() {
        if (this.identifier == null) {
            throw new RuntimeException("The Manifest resource requires an identifier.");
        }
        Manifest manifest = this.label != null ? new Manifest(this.identifier, this.label) : new Manifest(this.identifier);
        if (this.renderings.size() > 0) {
            manifest.setRenderings(this.renderings);
        }
        if (this.logo != null) {
            ArrayList<ImageContent> logos = new ArrayList<ImageContent>();
            logos.add(this.logo);
            manifest.setLogos(logos);
        }
        if (this.sequence != null) {
            manifest.addSequence(this.sequence, new Sequence[0]);
        }
        if (this.ranges.size() > 0) {
            for (Range range : this.ranges) {
                manifest.addRange(range, new Range[0]);
            }
        }
        if (this.metadata.size() > 0) {
            for (MetadataEntry meta : this.metadata) {
                manifest.addMetadata(new MetadataEntry[]{meta});
            }
        }
        if (this.seeAlso != null) {
            manifest.addSeeAlso(this.seeAlso, new OtherContent[0]);
        }
        if (this.related != null) {
            manifest.addRelated(this.related, new OtherContent[0]);
        }
        if (this.searchService != null) {
            manifest.addService((Service)this.searchService, new Service[0]);
        }
        if (this.license.size() > 0) {
            manifest.setLicenses(this.license);
        }
        if (this.description != null) {
            manifest.setDescription(this.description);
        }
        if (this.thumbnail != null) {
            manifest.addThumbnail(new ImageContent[]{this.thumbnail});
        }
        if (this.viewingHint != null) {
            manifest.addViewingHint(this.viewingHint, new ViewingHint[0]);
        }
        return manifest;
    }
}

