/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif.service;

import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.dspace.app.iiif.model.generator.AnnotationGenerator;
import org.dspace.app.iiif.model.generator.AnnotationListGenerator;
import org.dspace.app.iiif.model.generator.ExternalLinksGenerator;
import org.dspace.app.iiif.service.AbstractResourceService;
import org.dspace.app.iiif.service.utils.IIIFUtils;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
@Component
public class AnnotationListService
extends AbstractResourceService {
    @Autowired
    IIIFUtils utils;
    @Autowired
    ItemService itemService;
    @Autowired
    BitstreamService bitstreamService;
    @Autowired
    BitstreamFormatService bitstreamFormatService;
    @Autowired
    AnnotationListGenerator annotationList;

    public AnnotationListService(ConfigurationService configurationService) {
        this.setConfiguration(configurationService);
    }

    public String getSeeAlsoAnnotations(Context context, UUID id) throws RuntimeException {
        Item item;
        try {
            item = (Item)this.itemService.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.annotationList.setIdentifier(this.IIIF_ENDPOINT + id + "/manifest/seeAlso");
        List<Bitstream> bitstreams = this.utils.getSeeAlsoBitstreams(item);
        for (Bitstream bitstream : bitstreams) {
            String mimetype;
            try {
                BitstreamFormat format = bitstream.getFormat(context);
                mimetype = format.getMIMEType();
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            AnnotationGenerator annotation = new AnnotationGenerator(this.IIIF_ENDPOINT + bitstream.getID()).setMotivation(AnnotationGenerator.LINKING).setResource(this.getLinksGenerator(mimetype, bitstream));
            this.annotationList.addResource(annotation);
        }
        return this.utils.asJson(this.annotationList.generateResource());
    }

    private ExternalLinksGenerator getLinksGenerator(String mimetype, Bitstream bitstream) {
        String identifier = this.BITSTREAM_PATH_PREFIX + "/" + bitstream.getID() + "/content";
        return new ExternalLinksGenerator(identifier).setFormat(mimetype).setLabel(bitstream.getName());
    }
}

