/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif;

import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.iiif.service.AnnotationListService;
import org.dspace.app.iiif.service.CanvasLookupService;
import org.dspace.app.iiif.service.ManifestService;
import org.dspace.app.iiif.service.SearchService;
import org.dspace.app.iiif.service.utils.IIIFUtils;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Service
public class IIIFServiceFacade {
    @Autowired
    ItemService itemService;
    @Autowired
    BitstreamService bitstreamService;
    @Autowired
    ManifestService manifestService;
    @Autowired
    SearchService searchService;
    @Autowired
    AnnotationListService annotationListService;
    @Autowired
    CanvasLookupService canvasLookupService;
    @Autowired
    IIIFUtils utils;

    @Cacheable(key="#id.toString()", cacheNames={"manifests"})
    @PreAuthorize(value="hasPermission(#id, 'ITEM', 'READ')")
    public String getManifest(Context context, UUID id) throws ResourceNotFoundException {
        Item item;
        try {
            item = (Item)this.itemService.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (item == null || !this.utils.isIIIFEnabled(item)) {
            throw new ResourceNotFoundException("IIIF manifest for  id " + id + " not found");
        }
        return this.manifestService.getManifest(item, context);
    }

    @PreAuthorize(value="hasPermission(#id, 'ITEM', 'READ')")
    public String getCanvas(Context context, UUID id, String canvasId) throws ResourceNotFoundException {
        Item item;
        try {
            item = (Item)this.itemService.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (item == null) {
            throw new ResourceNotFoundException("IIIF canvas for  id " + id + " not found");
        }
        return this.canvasLookupService.generateCanvas(context, item, canvasId);
    }

    @PreAuthorize(value="hasPermission(#id, 'ITEM', 'READ')")
    public String searchInManifest(Context context, UUID id, String query) {
        return this.searchService.searchWithinManifest(id, query);
    }

    @PreAuthorize(value="hasPermission(#id, 'ITEM', 'READ')")
    public String getSeeAlsoAnnotations(Context context, UUID id) {
        return this.annotationListService.getSeeAlsoAnnotations(context, id);
    }
}

