/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif.service.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.iiif.model.ObjectMapperFactory;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.iiif.IIIFApiQueryService;
import org.dspace.iiif.util.IIIFSharedUtils;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class IIIFUtils {
    private static final Logger log = LogManager.getLogger(IIIFUtils.class);
    protected static final String OTHER_CONTENT_BUNDLE = "OtherContent";
    private static final String CANVAS_PATH_BASE = "/canvas/c";
    public static final String METADATA_IIIF_ENABLED = "dspace.iiif.enabled";
    public static final String METADATA_IIIF_SEARCH_ENABLED = "iiif.search.enabled";
    public static final String METADATA_IIIF_LABEL = "iiif.label";
    public static final String METADATA_IIIF_DESCRIPTION = "iiif.description";
    public static final String METADATA_IIIF_TOC = "iiif.toc";
    public static final String METADATA_IIIF_CANVAS_NAMING = "iiif.canvas.naming";
    public static final String METADATA_IIIF_VIEWING_HINT = "iiif.viewing.hint";
    public static final String METADATA_IMAGE_WIDTH = "iiif.image.width";
    public static final String METADATA_IMAGE_HEIGHT = "iiif.image.height";
    public static final String TOC_SEPARATOR = "|||";
    public static final String TOC_SEPARATOR_REGEX = "\\|\\|\\|";
    protected SimpleModule iiifModule = ObjectMapperFactory.getIiifModule();
    protected ObjectMapper mapper = ObjectMapperFactory.getIiifObjectMapper();
    @Autowired
    protected BitstreamService bitstreamService;
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    IIIFApiQueryService iiifApiQueryService;

    public List<Bundle> getIIIFBundles(Item item) {
        return IIIFSharedUtils.getIIIFBundles((Item)item);
    }

    public boolean isIIIFEnabled(Item item) {
        return IIIFSharedUtils.isIIIFEnabled((Item)item);
    }

    public List<Bitstream> getIIIFBitstreams(Context context, Item item) {
        ArrayList<Bitstream> bitstreams = new ArrayList<Bitstream>();
        for (Bundle bnd : IIIFSharedUtils.getIIIFBundles((Item)item)) {
            bitstreams.addAll(this.getIIIFBitstreams(context, bnd));
        }
        return bitstreams;
    }

    public List<Bitstream> getIIIFBitstreams(Context context, Bundle bundle) {
        return bundle.getBitstreams().stream().filter(b -> this.isIIIFBitstream(context, (Bitstream)b)).collect(Collectors.toList());
    }

    public boolean isIIIFBitstream(Context context, Bitstream b) {
        return this.checkImageMimeType(this.getBitstreamMimeType(b, context)) && b.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_ENABLED)).noneMatch(m -> m.getValue().equalsIgnoreCase("false") || m.getValue().equalsIgnoreCase("no"));
    }

    public String getBitstreamMimeType(Bitstream bitstream, Context context) {
        try {
            BitstreamFormat bitstreamFormat = bitstream.getFormat(context);
            return bitstreamFormat.getMIMEType();
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean isSearchable(Item item) {
        return item.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_SEARCH_ENABLED)).anyMatch(m -> m.getValue().equalsIgnoreCase("true") || m.getValue().equalsIgnoreCase("yes"));
    }

    public Bitstream getBitstreamForCanvas(Context context, Item item, int canvasPosition) {
        List<Bitstream> bitstreams = this.getIIIFBitstreams(context, item);
        return bitstreams.size() > canvasPosition ? bitstreams.get(canvasPosition) : null;
    }

    public int getCanvasId(String canvasId) {
        return Integer.parseInt(canvasId.substring(1));
    }

    public String getCanvasId(int position) {
        return CANVAS_PATH_BASE + position;
    }

    public String asJson(Resource<?> resource) {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.registerModule((Module)this.iiifModule);
        try {
            return this.mapper.writeValueAsString(resource);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private boolean checkImageMimeType(String mimetype) {
        return mimetype != null && mimetype.contains("image/");
    }

    public List<Bitstream> getSeeAlsoBitstreams(Item item) {
        ArrayList<Bitstream> seeAlsoBitstreams = new ArrayList<Bitstream>();
        List bundles = item.getBundles(OTHER_CONTENT_BUNDLE);
        if (bundles.size() > 0) {
            for (Bundle bundle : bundles) {
                List bitstreams = bundle.getBitstreams();
                seeAlsoBitstreams.addAll(bitstreams);
            }
        }
        return seeAlsoBitstreams;
    }

    public String getIIIFLabel(DSpaceObject dso, String defaultLabel) {
        return dso.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_LABEL)).findFirst().map(m -> m.getValue()).orElse(defaultLabel);
    }

    public String getIIIFDescription(DSpaceObject dso, String defaultDescription) {
        return dso.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_DESCRIPTION)).findFirst().map(m -> m.getValue()).orElse(defaultDescription);
    }

    public List<String> getIIIFToCs(Bitstream bitstream, String prefix) {
        List<String> tocs = bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_TOC)).map(m -> StringUtils.isNotBlank((CharSequence)prefix) ? prefix + TOC_SEPARATOR + m.getValue() : m.getValue()).collect(Collectors.toList());
        if (tocs.size() == 0 && StringUtils.isNotBlank((CharSequence)prefix)) {
            return List.of(prefix);
        }
        return tocs;
    }

    @Cacheable(key="#bitstream.getID().toString()", cacheNames={"canvasdimensions"})
    public int[] getImageDimensions(Bitstream bitstream) {
        return this.iiifApiQueryService.getImageDimensions(bitstream);
    }

    public boolean hasWidthMetadata(Bitstream bitstream) {
        return bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IMAGE_WIDTH)).findFirst().map(m -> m != null).orElse(false);
    }

    public String getBundleIIIFToC(Bundle bundle) {
        String label = bundle.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_LABEL)).findFirst().map(m -> m.getValue()).orElse(this.getToCBundleLabel(bundle));
        return bundle.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_TOC)).findFirst().map(m -> m.getValue() + TOC_SEPARATOR + label).orElse(label);
    }

    private String getToCBundleLabel(Bundle bundle) {
        String[] iiifAlternate = this.configurationService.getArrayProperty("iiif.exclude.toc.bundle");
        if (Arrays.stream(iiifAlternate).anyMatch(x -> x.contentEquals(bundle.getName()))) {
            return null;
        }
        return bundle.getName();
    }

    public String getIIIFViewingHint(Item item, String defaultHint) {
        return item.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_VIEWING_HINT)).findFirst().map(m -> m.getValue()).orElse(defaultHint);
    }

    public int getCanvasWidth(Bitstream bitstream, Bundle bundle, Item item, int defaultWidth) {
        return this.getSizeFromMetadata((DSpaceObject)bitstream, METADATA_IMAGE_WIDTH, this.getSizeFromMetadata((DSpaceObject)bundle, METADATA_IMAGE_WIDTH, this.getSizeFromMetadata((DSpaceObject)item, METADATA_IMAGE_WIDTH, defaultWidth)));
    }

    public int getCanvasHeight(Bitstream bitstream, Bundle bundle, Item item, int defaultHeight) {
        return this.getSizeFromMetadata((DSpaceObject)bitstream, METADATA_IMAGE_HEIGHT, this.getSizeFromMetadata((DSpaceObject)bundle, METADATA_IMAGE_HEIGHT, this.getSizeFromMetadata((DSpaceObject)item, METADATA_IMAGE_HEIGHT, defaultHeight)));
    }

    private int getSizeFromMetadata(DSpaceObject dso, String metadata, int defaultValue) {
        return dso.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(metadata)).findFirst().map(m -> this.castToInt((MetadataValue)m, defaultValue)).orElse(defaultValue);
    }

    private int castToInt(MetadataValue m, int defaultInt) {
        try {
            return Integer.parseInt(m.getValue());
        }
        catch (NumberFormatException e) {
            log.error("Error parsing " + m.getMetadataField().toString('.') + " of " + m.getDSpaceObject().getID() + " the value " + m.getValue() + " is not an integer. Returning the default.");
            return defaultInt;
        }
    }

    public String getCanvasNaming(Item item, String defaultNaming) {
        return item.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_CANVAS_NAMING)).findFirst().map(m -> m.getValue()).orElse(defaultNaming);
    }
}

