/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif.service;

import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.iiif.exception.NotImplementedException;
import org.dspace.app.iiif.service.AbstractResourceService;
import org.dspace.app.iiif.service.SearchAnnotationService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
@Component
public class SearchService
extends AbstractResourceService {
    private static final Logger log = LogManager.getLogger(SearchService.class);
    private final String searchPlugin;
    @Autowired
    List<SearchAnnotationService> annotationService;

    public SearchService(ConfigurationService configurationService) {
        this.setConfiguration(configurationService);
        this.searchPlugin = configurationService.getProperty("iiif.search.plugin");
    }

    public String searchWithinManifest(UUID uuid, String query) throws NotImplementedException {
        if (this.searchPlugin != null) {
            for (SearchAnnotationService service : this.annotationService) {
                if (!service.useSearchPlugin(this.searchPlugin)) continue;
                service.initializeQuerySettings(this.IIIF_ENDPOINT, this.getManifestId(uuid));
                return service.getSearchResponse(uuid, query);
            }
        }
        throw new NotImplementedException("The IIIF search option is not enabled for this server.");
    }
}

